/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.Subscriptions;

public final class OperationOnErrorReturn<T> {
    public static <T> Observable.OnSubscribeFunc<T> onErrorReturn(Observable<? extends T> originalSequence, Func1<Throwable, ? extends T> resumeFunction) {
        return new OnErrorReturn<T>(originalSequence, resumeFunction);
    }

    private static class OnErrorReturn<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Func1<Throwable, ? extends T> resumeFunction;
        private final Observable<? extends T> originalSequence;

        public OnErrorReturn(Observable<? extends T> originalSequence, Func1<Throwable, ? extends T> resumeFunction) {
            this.resumeFunction = resumeFunction;
            this.originalSequence = originalSequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            SafeObservableSubscription subscription = new SafeObservableSubscription();
            final AtomicReference<SafeObservableSubscription> subscriptionRef = new AtomicReference<SafeObservableSubscription>(subscription);
            subscription.wrap(this.originalSequence.unsafeSubscribe(new Subscriber<T>(){

                @Override
                public void onNext(T value) {
                    observer.onNext(value);
                }

                @Override
                public void onError(Throwable ex) {
                    SafeObservableSubscription currentSubscription = (SafeObservableSubscription)subscriptionRef.get();
                    if (currentSubscription != null) {
                        try {
                            this.onNext(OnErrorReturn.this.resumeFunction.call(ex));
                            this.onCompleted();
                            currentSubscription.unsubscribe();
                        }
                        catch (Throwable e) {
                            observer.onError(new CompositeException("OnErrorReturn function failed", Arrays.asList(ex, e)));
                        }
                    }
                }

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }
            }));
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    Subscription s = subscriptionRef.getAndSet(null);
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
            });
        }
    }
}

