/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.observers.Subscribers;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.Subscriptions;

public final class OperationOnExceptionResumeNextViaObservable<T> {
    public static <T> Observable.OnSubscribeFunc<T> onExceptionResumeNextViaObservable(Observable<? extends T> originalSequence, Observable<? extends T> resumeSequence) {
        return new OnExceptionResumeNextViaObservable<T>(originalSequence, resumeSequence);
    }

    private static class OnExceptionResumeNextViaObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> resumeSequence;
        private final Observable<? extends T> originalSequence;

        public OnExceptionResumeNextViaObservable(Observable<? extends T> originalSequence, Observable<? extends T> resumeSequence) {
            this.resumeSequence = resumeSequence;
            this.originalSequence = originalSequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            final AtomicReference<SafeObservableSubscription> subscriptionRef = new AtomicReference<SafeObservableSubscription>(subscription);
            subscription.wrap(this.originalSequence.unsafeSubscribe(new Subscriber<T>(){

                @Override
                public void onNext(T value) {
                    if (subscriptionRef.get() == subscription) {
                        observer.onNext(value);
                    }
                }

                @Override
                public void onError(Throwable ex) {
                    if (ex instanceof Exception) {
                        SafeObservableSubscription innerSubscription;
                        SafeObservableSubscription currentSubscription = (SafeObservableSubscription)subscriptionRef.get();
                        if (currentSubscription == subscription && !subscriptionRef.compareAndSet(currentSubscription, innerSubscription = new SafeObservableSubscription(OnExceptionResumeNextViaObservable.this.resumeSequence.unsafeSubscribe(Subscribers.from(observer))))) {
                            innerSubscription.unsubscribe();
                        }
                    } else {
                        observer.onError(ex);
                    }
                }

                @Override
                public void onCompleted() {
                    if (subscriptionRef.get() == subscription) {
                        observer.onCompleted();
                    }
                }
            }));
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    Subscription s = subscriptionRef.getAndSet(null);
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
            });
        }
    }
}

