/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.CompositeSubscription;

public final class OperationSkip {

    public static final class SkipTimed<T>
    implements Observable.OnSubscribeFunc<T> {
        final Observable<? extends T> source;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;

        public SkipTimed(Observable<? extends T> source, long time, TimeUnit unit, Scheduler scheduler) {
            this.source = source;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> t1) {
            SafeObservableSubscription timer = new SafeObservableSubscription();
            SafeObservableSubscription data = new SafeObservableSubscription();
            CompositeSubscription csub = new CompositeSubscription(timer, data);
            SourceObserver<? super T> so = new SourceObserver<T>(t1, csub);
            data.wrap(this.source.unsafeSubscribe(so));
            if (!data.isUnsubscribed()) {
                timer.wrap(this.scheduler.schedule(so, this.time, this.unit));
            }
            return csub;
        }

        private static final class SourceObserver<T>
        extends Subscriber<T>
        implements Action1<Scheduler.Inner> {
            final AtomicBoolean gate = new AtomicBoolean();
            final Observer<? super T> observer;
            final Subscription cancel;

            public SourceObserver(Observer<? super T> observer, Subscription cancel) {
                this.observer = observer;
                this.cancel = cancel;
            }

            @Override
            public void onNext(T args) {
                if (this.gate.get()) {
                    this.observer.onNext(args);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                try {
                    this.observer.onError(e);
                }
                finally {
                    this.cancel.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                try {
                    this.observer.onCompleted();
                }
                finally {
                    this.cancel.unsubscribe();
                }
            }

            @Override
            public void call(Scheduler.Inner inner) {
                this.gate.set(true);
            }
        }
    }
}

