/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.schedulers.Timestamped;

public class OperationSkipLast {
    public static <T> Observable.OnSubscribeFunc<T> skipLast(Observable<? extends T> source, int count) {
        return new SkipLast(source, count);
    }

    public static final class SkipLastTimed<T>
    implements Observable.OnSubscribeFunc<T> {
        final Observable<? extends T> source;
        final long timeInMillis;
        final Scheduler scheduler;

        public SkipLastTimed(Observable<? extends T> source, long time, TimeUnit unit, Scheduler scheduler) {
            this.source = source;
            this.timeInMillis = unit.toMillis(time);
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> t1) {
            return this.source.unsafeSubscribe(new SourceObserver<T>(t1, this.timeInMillis, this.scheduler));
        }

        private static final class SourceObserver<T>
        extends Subscriber<T> {
            final Observer<? super T> observer;
            final long timeInMillis;
            final Scheduler scheduler;
            List<Timestamped<T>> buffer = new ArrayList<Timestamped<T>>();

            public SourceObserver(Observer<? super T> observer, long timeInMillis, Scheduler scheduler) {
                this.observer = observer;
                this.timeInMillis = timeInMillis;
                this.scheduler = scheduler;
            }

            @Override
            public void onNext(T args) {
                this.buffer.add(new Timestamped<T>(this.scheduler.now(), args));
            }

            @Override
            public void onError(Throwable e) {
                this.buffer = Collections.emptyList();
                this.observer.onError(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                long limit = this.scheduler.now() - this.timeInMillis;
                try {
                    for (Timestamped<T> v : this.buffer) {
                        if (v.getTimestampMillis() < limit) {
                            try {
                                this.observer.onNext(v.getValue());
                                continue;
                            }
                            catch (Throwable t) {
                                this.observer.onError(t);
                                this.buffer = Collections.emptyList();
                                return;
                            }
                        }
                        this.observer.onCompleted();
                        break;
                    }
                }
                finally {
                    this.buffer = Collections.emptyList();
                }
            }
        }
    }

    private static class SkipLast<T>
    implements Observable.OnSubscribeFunc<T> {
        private final int count;
        private final Observable<? extends T> source;

        private SkipLast(Observable<? extends T> source, int count) {
            this.count = count;
            this.source = source;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            if (this.count < 0) {
                throw new IndexOutOfBoundsException("count could not be negative");
            }
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.source.unsafeSubscribe(new Subscriber<T>(){
                private final ReentrantLock lock = new ReentrantLock();
                private final Deque<T> deque = new LinkedList();

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNext(T value) {
                    if (SkipLast.this.count == 0) {
                        try {
                            observer.onNext(value);
                        }
                        catch (Throwable ex) {
                            observer.onError(ex);
                            subscription.unsubscribe();
                        }
                        return;
                    }
                    this.lock.lock();
                    try {
                        this.deque.offerLast(value);
                        if (this.deque.size() > SkipLast.this.count) {
                            observer.onNext(this.deque.removeFirst());
                        }
                    }
                    catch (Throwable ex) {
                        observer.onError(ex);
                        subscription.unsubscribe();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }));
        }
    }
}

