/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.functions.Func2;

public final class OperationSum {
    private static final Func2<Integer, Integer, Integer> ACCUM_INT = new Func2<Integer, Integer, Integer>(){

        @Override
        public Integer call(Integer accu, Integer next) {
            return accu + next;
        }
    };
    private static final Func2<Long, Long, Long> ACCUM_LONG = new Func2<Long, Long, Long>(){

        @Override
        public Long call(Long accu, Long next) {
            return accu + next;
        }
    };
    private static final Func2<Float, Float, Float> ACCUM_FLOAT = new Func2<Float, Float, Float>(){

        @Override
        public Float call(Float accu, Float next) {
            return Float.valueOf(accu.floatValue() + next.floatValue());
        }
    };
    private static final Func2<Double, Double, Double> ACCUM_DOUBLE = new Func2<Double, Double, Double>(){

        @Override
        public Double call(Double accu, Double next) {
            return accu + next;
        }
    };

    public static Observable<Integer> sumIntegers(Observable<Integer> source) {
        return source.reduce(0, ACCUM_INT);
    }

    public static Observable<Long> sumLongs(Observable<Long> source) {
        return source.reduce(0L, ACCUM_LONG);
    }

    public static Observable<Float> sumFloats(Observable<Float> source) {
        return source.reduce(Float.valueOf(0.0f), ACCUM_FLOAT);
    }

    public static Observable<Double> sumDoubles(Observable<Double> source) {
        return source.reduce(0.0, ACCUM_DOUBLE);
    }

    public static Observable<Integer> sumAtLeastOneIntegers(Observable<Integer> source) {
        return source.reduce(ACCUM_INT);
    }

    public static Observable<Long> sumAtLeastOneLongs(Observable<Long> source) {
        return source.reduce(ACCUM_LONG);
    }

    public static Observable<Float> sumAtLeastOneFloats(Observable<Float> source) {
        return source.reduce(ACCUM_FLOAT);
    }

    public static Observable<Double> sumAtLeastOneDoubles(Observable<Double> source) {
        return source.reduce(ACCUM_DOUBLE);
    }
}

