/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public final class OperationTakeTimed {
    public static <T> Observable.OnSubscribeFunc<T> take(final Observable<? extends T> items, final int num) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Take(items, num).onSubscribe(observer);
            }
        };
    }

    public static final class TakeTimed<T>
    implements Observable.OnSubscribeFunc<T> {
        final Observable<? extends T> source;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;

        public TakeTimed(Observable<? extends T> source, long time, TimeUnit unit, Scheduler scheduler) {
            this.source = source;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> t1) {
            SafeObservableSubscription timer = new SafeObservableSubscription();
            SafeObservableSubscription data = new SafeObservableSubscription();
            CompositeSubscription csub = new CompositeSubscription(timer, data);
            SourceObserver<? super T> so = new SourceObserver<T>(t1, csub);
            data.wrap(this.source.unsafeSubscribe(so));
            if (!data.isUnsubscribed()) {
                timer.wrap(this.scheduler.schedule(so, this.time, this.unit));
            }
            return csub;
        }

        private static final class SourceObserver<T>
        extends Subscriber<T>
        implements Action1<Scheduler.Inner> {
            final Observer<? super T> observer;
            final Subscription cancel;
            final AtomicInteger state = new AtomicInteger();
            static final int ACTIVE = 0;
            static final int NEXT = 1;
            static final int DONE = 2;

            public SourceObserver(Observer<? super T> observer, Subscription cancel) {
                this.observer = observer;
                this.cancel = cancel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T args) {
                int s;
                do {
                    if ((s = this.state.get()) != 2) continue;
                    return;
                } while (!this.state.compareAndSet(s, 1));
                try {
                    this.observer.onNext(args);
                }
                finally {
                    this.state.set(0);
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                int s;
                do {
                    if ((s = this.state.get()) != 2) continue;
                    return;
                } while (s == 1 || !this.state.compareAndSet(s, 2));
                try {
                    this.observer.onError(e);
                }
                finally {
                    this.cancel.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                int s;
                do {
                    if ((s = this.state.get()) != 2) continue;
                    return;
                } while (s == 1 || !this.state.compareAndSet(s, 2));
                try {
                    this.observer.onCompleted();
                }
                finally {
                    this.cancel.unsubscribe();
                }
            }

            @Override
            public void call(Scheduler.Inner inner) {
                this.onCompleted();
            }
        }
    }

    private static class Take<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> items;
        private final int num;
        private final SafeObservableSubscription subscription = new SafeObservableSubscription();

        private Take(Observable<? extends T> items, int num) {
            this.items = items;
            this.num = num;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            if (this.num < 1) {
                this.items.unsafeSubscribe(new Subscriber<T>(){

                    @Override
                    public void onCompleted() {
                    }

                    @Override
                    public void onError(Throwable e) {
                    }

                    @Override
                    public void onNext(T args) {
                    }
                }).unsubscribe();
                observer.onCompleted();
                return Subscriptions.empty();
            }
            return this.subscription.wrap(this.items.unsafeSubscribe(new ItemObserver(observer)));
        }

        private class ItemObserver
        extends Subscriber<T> {
            private final Observer<? super T> observer;
            private final AtomicInteger counter = new AtomicInteger();
            private volatile boolean hasEmitedError = false;

            public ItemObserver(Observer<? super T> observer) {
                this.observer = observer;
            }

            @Override
            public void onCompleted() {
                if (this.hasEmitedError) {
                    return;
                }
                if (this.counter.getAndSet(Take.this.num) < Take.this.num) {
                    this.observer.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (this.hasEmitedError) {
                    return;
                }
                if (this.counter.getAndSet(Take.this.num) < Take.this.num) {
                    this.observer.onError(e);
                }
            }

            @Override
            public void onNext(T args) {
                if (this.hasEmitedError) {
                    return;
                }
                int count = this.counter.incrementAndGet();
                if (count <= Take.this.num) {
                    try {
                        this.observer.onNext(args);
                    }
                    catch (Throwable ex) {
                        this.hasEmitedError = true;
                        this.observer.onError(ex);
                        Take.this.subscription.unsubscribe();
                        return;
                    }
                    if (count == Take.this.num) {
                        this.observer.onCompleted();
                    }
                }
                if (count >= Take.this.num) {
                    Take.this.subscription.unsubscribe();
                }
            }
        }
    }
}

