/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;

public final class OperationTakeWhile {
    public static <T> Observable.OnSubscribeFunc<T> takeWhile(Observable<? extends T> items, Func1<? super T, Boolean> predicate) {
        return OperationTakeWhile.takeWhileWithIndex(items, OperationTakeWhile.skipIndex(predicate));
    }

    public static <T> Observable.OnSubscribeFunc<T> takeWhileWithIndex(final Observable<? extends T> items, final Func2<? super T, ? super Integer, Boolean> predicate) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new TakeWhile(items, predicate).onSubscribe(observer);
            }
        };
    }

    private static <T> Func2<T, Integer, Boolean> skipIndex(final Func1<? super T, Boolean> underlying) {
        return new Func2<T, Integer, Boolean>(){

            @Override
            public Boolean call(T input, Integer index) {
                return (Boolean)underlying.call(input);
            }
        };
    }

    private static class TakeWhile<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> items;
        private final Func2<? super T, ? super Integer, Boolean> predicate;
        private final SafeObservableSubscription subscription = new SafeObservableSubscription();

        private TakeWhile(Observable<? extends T> items, Func2<? super T, ? super Integer, Boolean> predicate) {
            this.items = items;
            this.predicate = predicate;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.subscription.wrap(this.items.unsafeSubscribe(new ItemObserver(observer)));
        }

        private class ItemObserver
        extends Subscriber<T> {
            private final Observer<? super T> observer;
            private final AtomicInteger counter = new AtomicInteger();

            public ItemObserver(Observer<? super T> observer) {
                this.observer = new SafeObserver(TakeWhile.this.subscription, observer);
            }

            @Override
            public void onCompleted() {
                this.observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onNext(T args) {
                Boolean isSelected;
                try {
                    isSelected = (Boolean)TakeWhile.this.predicate.call(args, this.counter.getAndIncrement());
                }
                catch (Throwable e) {
                    this.observer.onError(e);
                    return;
                }
                if (isSelected.booleanValue()) {
                    this.observer.onNext(args);
                } else {
                    this.observer.onCompleted();
                    TakeWhile.this.subscription.unsubscribe();
                }
            }
        }
    }
}

