/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Func1;
import rx.observers.Subscribers;
import rx.schedulers.Schedulers;

public final class OperationThrottleFirst {
    public static <T> Observable.OnSubscribeFunc<T> throttleFirst(Observable<T> items, long windowDuration, TimeUnit unit) {
        return OperationThrottleFirst.throttleFirst(items, windowDuration, unit, Schedulers.computation());
    }

    public static <T> Observable.OnSubscribeFunc<T> throttleFirst(final Observable<T> items, final long windowDuration, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                final AtomicLong lastOnNext = new AtomicLong(0L);
                final long timeInMilliseconds = unit.toMillis(windowDuration);
                return items.filter(new Func1<T, Boolean>(){

                    @Override
                    public Boolean call(T value) {
                        long now = scheduler.now();
                        if (lastOnNext.get() == 0L || now - lastOnNext.get() >= timeInMilliseconds) {
                            lastOnNext.set(now);
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                }).unsafeSubscribe(Subscribers.from(observer));
            }
        };
    }
}

