/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;

public final class OperationTimer {
    private OperationTimer() {
        throw new IllegalStateException("No instances!");
    }

    public static class TimerPeriodically
    implements Observable.OnSubscribeFunc<Long> {
        private final Scheduler scheduler;
        private final long initialDelay;
        private final long period;
        private final TimeUnit unit;

        public TimerPeriodically(long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
            this.scheduler = scheduler;
            this.initialDelay = initialDelay;
            this.period = period;
            this.unit = unit;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super Long> t1) {
            return this.scheduler.schedulePeriodically(new Action1<Scheduler.Inner>(){
                long count;

                @Override
                public void call(Scheduler.Inner inner) {
                    t1.onNext(this.count++);
                }
            }, this.initialDelay, this.period, this.unit);
        }
    }

    public static class TimerOnce
    implements Observable.OnSubscribeFunc<Long> {
        private final Scheduler scheduler;
        private final long dueTime;
        private final TimeUnit dueUnit;

        public TimerOnce(long dueTime, TimeUnit unit, Scheduler scheduler) {
            this.scheduler = scheduler;
            this.dueTime = dueTime;
            this.dueUnit = unit;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super Long> t1) {
            return this.scheduler.schedule(new Action1<Scheduler.Inner>(){

                @Override
                public void call(Scheduler.Inner inner) {
                    t1.onNext(0L);
                    t1.onCompleted();
                }
            }, this.dueTime, this.dueUnit);
        }
    }
}

