/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Subscriber;
import rx.observers.Subscribers;
import rx.subjects.ReplaySubject;
import rx.subjects.Subject;

public final class OperatorCache<T>
implements Observable.OnSubscribe<T> {
    protected final Observable<? extends T> source;
    protected final Subject<? super T, ? extends T> cache;
    protected final AtomicBoolean sourceSubscribed;

    public OperatorCache(Observable<? extends T> source) {
        this(source, ReplaySubject.create());
    }

    OperatorCache(Observable<? extends T> source, Subject<? super T, ? extends T> cache) {
        this.source = source;
        this.cache = cache;
        this.sourceSubscribed = new AtomicBoolean();
    }

    @Override
    public void call(Subscriber<? super T> s) {
        if (this.sourceSubscribed.compareAndSet(false, true)) {
            this.source.unsafeSubscribe(Subscribers.from(this.cache));
        }
        this.cache.unsafeSubscribe(s);
    }
}

