/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.CompositeSubscription;

public final class OperatorMerge<T>
implements Observable.Operator<T, Observable<? extends T>> {
    @Override
    public Subscriber<Observable<? extends T>> call(Subscriber<? super T> outerOperation) {
        final SerializedSubscriber<? super T> o = new SerializedSubscriber<T>(outerOperation);
        final CompositeSubscription childrenSubscriptions = new CompositeSubscription();
        outerOperation.add(childrenSubscriptions);
        return new Subscriber<Observable<? extends T>>(outerOperation){
            private volatile boolean completed;
            private final AtomicInteger runningCount;
            {
                super(x0);
                this.completed = false;
                this.runningCount = new AtomicInteger();
            }

            @Override
            public void onCompleted() {
                this.completed = true;
                if (this.runningCount.get() == 0) {
                    o.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                o.onError(e);
            }

            @Override
            public void onNext(Observable<? extends T> innerObservable) {
                this.runningCount.incrementAndGet();
                InnerObserver i = new InnerObserver();
                childrenSubscriptions.add(i);
                innerObservable.unsafeSubscribe(i);
            }

            final class InnerObserver
            extends Subscriber<T> {
                private boolean innerCompleted = false;

                @Override
                public void onCompleted() {
                    if (!this.innerCompleted) {
                        this.innerCompleted = true;
                        if (runningCount.decrementAndGet() == 0 && completed) {
                            o.onCompleted();
                        }
                        this.cleanup();
                    }
                }

                @Override
                public void onError(Throwable e) {
                    o.onError(e);
                    this.cleanup();
                }

                @Override
                public void onNext(T a) {
                    o.onNext(a);
                }

                private void cleanup() {
                    childrenSubscriptions.remove(this);
                }
            }
        };
    }
}

