/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action1;
import rx.operators.NotificationLite;
import rx.schedulers.ImmediateScheduler;
import rx.schedulers.TrampolineScheduler;

public class OperatorObserveOn<T>
implements Observable.Operator<T, T> {
    private final Scheduler scheduler;
    private final NotificationLite<T> on = NotificationLite.instance();

    public OperatorObserveOn(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        if (this.scheduler instanceof ImmediateScheduler) {
            return child;
        }
        if (this.scheduler instanceof TrampolineScheduler) {
            return child;
        }
        return new ObserveOnSubscriber(child);
    }

    private class ObserveOnSubscriber
    extends Subscriber<T> {
        final Subscriber<? super T> observer;
        private volatile Scheduler.Inner recursiveScheduler;
        private final ConcurrentLinkedQueue<Object> queue;
        final AtomicLong counter;

        public ObserveOnSubscriber(Subscriber<? super T> observer) {
            super(observer);
            this.queue = new ConcurrentLinkedQueue();
            this.counter = new AtomicLong(0L);
            this.observer = observer;
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(OperatorObserveOn.this.on.next(t));
            this.schedule();
        }

        @Override
        public void onCompleted() {
            this.queue.offer(OperatorObserveOn.this.on.completed());
            this.schedule();
        }

        @Override
        public void onError(Throwable e) {
            this.queue.offer(OperatorObserveOn.this.on.error(e));
            this.schedule();
        }

        protected void schedule() {
            if (this.counter.getAndIncrement() == 0L) {
                if (this.recursiveScheduler == null) {
                    this.add(OperatorObserveOn.this.scheduler.schedule(new Action1<Scheduler.Inner>(){

                        @Override
                        public void call(Scheduler.Inner inner) {
                            ObserveOnSubscriber.this.recursiveScheduler = inner;
                            ObserveOnSubscriber.this.pollQueue();
                        }
                    }));
                } else {
                    this.recursiveScheduler.schedule(new Action1<Scheduler.Inner>(){

                        @Override
                        public void call(Scheduler.Inner inner) {
                            ObserveOnSubscriber.this.pollQueue();
                        }
                    });
                }
            }
        }

        private void pollQueue() {
            do {
                Object v = this.queue.poll();
                OperatorObserveOn.this.on.accept(this.observer, v);
            } while (this.counter.decrementAndGet() > 0L);
        }
    }
}

