/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Func1;
import rx.observables.GroupedObservable;
import rx.operators.OperatorGroupBy;
import rx.operators.OperatorMap;
import rx.operators.OperatorMerge;

public final class OperatorParallel<T, R>
implements Observable.Operator<R, T> {
    private final Scheduler scheduler;
    private final Func1<Observable<T>, Observable<R>> f;
    private final int degreeOfParallelism;

    public OperatorParallel(Func1<Observable<T>, Observable<R>> f, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.f = f;
        this.degreeOfParallelism = scheduler.degreeOfParallelism();
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> op) {
        OperatorGroupBy groupBy = new OperatorGroupBy(new Func1<T, Long>(){
            long i = 0L;

            @Override
            public Long call(T t) {
                return this.i++ % (long)OperatorParallel.this.degreeOfParallelism;
            }
        });
        OperatorMap map = new OperatorMap(new Func1<GroupedObservable<Long, T>, Observable<R>>(){

            @Override
            public Observable<R> call(GroupedObservable<Long, T> g) {
                return (Observable)OperatorParallel.this.f.call(g.observeOn(OperatorParallel.this.scheduler));
            }
        });
        return (Subscriber)groupBy.call(map.call(new OperatorMerge<R>().call(op)));
    }
}

