/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action1;
import rx.observers.Subscribers;
import rx.schedulers.Schedulers;

public class OperatorRepeat<T>
implements Observable.Operator<T, Observable<T>> {
    private final Scheduler scheduler;
    private final long count;

    public OperatorRepeat(long count, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.count = count;
    }

    public OperatorRepeat(Scheduler scheduler) {
        this(-1L, scheduler);
    }

    public OperatorRepeat(long count) {
        this(count, Schedulers.trampoline());
    }

    public OperatorRepeat() {
        this(-1L, Schedulers.trampoline());
    }

    @Override
    public Subscriber<? super Observable<T>> call(final Subscriber<? super T> child) {
        if (this.count == 0L) {
            child.onCompleted();
            return Subscribers.empty();
        }
        return new Subscriber<Observable<T>>(child){
            int executionCount;
            {
                super(x0);
                this.executionCount = 0;
            }

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                child.onError(new IllegalStateException("Error received on nested Observable.", e));
            }

            @Override
            public void onNext(final Observable<T> t) {
                OperatorRepeat.this.scheduler.schedule(new Action1<Scheduler.Inner>(){
                    final Action1<Scheduler.Inner> self = this;

                    @Override
                    public void call(final Scheduler.Inner inner) {
                        ++executionCount;
                        t.unsafeSubscribe(new Subscriber<T>(child){

                            @Override
                            public void onCompleted() {
                                if (OperatorRepeat.this.count == -1L || (long)executionCount < OperatorRepeat.this.count) {
                                    inner.schedule(self);
                                } else {
                                    child.onCompleted();
                                }
                            }

                            @Override
                            public void onError(Throwable e) {
                                child.onError(e);
                            }

                            @Override
                            public void onNext(T t) {
                                child.onNext(t);
                            }
                        });
                    }
                });
            }
        };
    }
}

