/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.SerialSubscription;

class OperatorTimeoutBase<T>
implements Observable.Operator<T, T> {
    private final FirstTimeoutStub<T> firstTimeoutStub;
    private final TimeoutStub<T> timeoutStub;
    private final Observable<? extends T> other;

    OperatorTimeoutBase(FirstTimeoutStub<T> firstTimeoutStub, TimeoutStub<T> timeoutStub, Observable<? extends T> other) {
        this.firstTimeoutStub = firstTimeoutStub;
        this.timeoutStub = timeoutStub;
        this.other = other;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> subscriber) {
        SerialSubscription serial = new SerialSubscription();
        subscriber.add(serial);
        SerializedSubscriber<? super T> synchronizedSubscriber = new SerializedSubscriber<T>(subscriber);
        TimeoutSubscriber timeoutSubscriber = new TimeoutSubscriber(synchronizedSubscriber, this.timeoutStub, serial, this.other);
        serial.set((Subscription)this.firstTimeoutStub.call(timeoutSubscriber, 0L));
        return timeoutSubscriber;
    }

    static class TimeoutSubscriber<T>
    extends Subscriber<T> {
        private final AtomicBoolean terminated = new AtomicBoolean(false);
        private final AtomicLong actual = new AtomicLong(0L);
        private final SerialSubscription serial;
        private final Object gate = new Object();
        private final SerializedSubscriber<T> serializedSubscriber;
        private final TimeoutStub<T> timeoutStub;
        private final Observable<? extends T> other;

        private TimeoutSubscriber(SerializedSubscriber<T> serializedSubscriber, TimeoutStub<T> timeoutStub, SerialSubscription serial, Observable<? extends T> other) {
            super(serializedSubscriber);
            this.serializedSubscriber = serializedSubscriber;
            this.timeoutStub = timeoutStub;
            this.serial = serial;
            this.other = other;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T value) {
            boolean onNextWins = false;
            Object object = this.gate;
            synchronized (object) {
                if (!this.terminated.get()) {
                    this.actual.incrementAndGet();
                    onNextWins = true;
                }
            }
            if (onNextWins) {
                this.serializedSubscriber.onNext(value);
                this.serial.set((Subscription)this.timeoutStub.call(this, this.actual.get(), value));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable error) {
            boolean onErrorWins = false;
            Object object = this.gate;
            synchronized (object) {
                if (!this.terminated.getAndSet(true)) {
                    onErrorWins = true;
                }
            }
            if (onErrorWins) {
                this.serial.unsubscribe();
                this.serializedSubscriber.onError(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            boolean onCompletedWins = false;
            Object object = this.gate;
            synchronized (object) {
                if (!this.terminated.getAndSet(true)) {
                    onCompletedWins = true;
                }
            }
            if (onCompletedWins) {
                this.serial.unsubscribe();
                this.serializedSubscriber.onCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimeout(long seqId) {
            long expected = seqId;
            boolean timeoutWins = false;
            Object object = this.gate;
            synchronized (object) {
                if (expected == this.actual.get() && !this.terminated.getAndSet(true)) {
                    timeoutWins = true;
                }
            }
            if (timeoutWins) {
                if (this.other == null) {
                    this.serializedSubscriber.onError(new TimeoutException());
                } else {
                    this.other.unsafeSubscribe(this.serializedSubscriber);
                    this.serial.set(this.serializedSubscriber);
                }
            }
        }
    }

    static interface TimeoutStub<T>
    extends Func3<TimeoutSubscriber<T>, Long, T, Subscription> {
    }

    static interface FirstTimeoutStub<T>
    extends Func2<TimeoutSubscriber<T>, Long, Subscription> {
    }
}

