/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.functions.Func5;
import rx.functions.Func6;
import rx.functions.Func7;
import rx.functions.Func8;
import rx.functions.Func9;
import rx.functions.FuncN;
import rx.functions.Functions;
import rx.operators.NotificationLite;
import rx.subscriptions.CompositeSubscription;

public final class OperatorZip<R>
implements Observable.Operator<R, Observable<?>[]> {
    final FuncN<? extends R> zipFunction;
    static final NotificationLite on = NotificationLite.instance();

    public OperatorZip(FuncN<? extends R> f) {
        this.zipFunction = f;
    }

    public OperatorZip(Func2 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func3 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func4 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func5 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func6 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func7 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func8 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func9 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    @Override
    public Subscriber<? super Observable[]> call(final Subscriber<? super R> observer) {
        return new Subscriber<Observable[]>(observer){
            boolean started;
            {
                super(x0);
                this.started = false;
            }

            @Override
            public void onCompleted() {
                if (!this.started) {
                    observer.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                observer.onError(e);
            }

            @Override
            public void onNext(Observable[] observables) {
                if (observables == null || observables.length == 0) {
                    observer.onCompleted();
                } else {
                    this.started = true;
                    new Zip(observables, observer, OperatorZip.this.zipFunction).zip();
                }
            }
        };
    }

    private static class Zip<R> {
        final Observable[] os;
        final Object[] observers;
        final Observer<? super R> observer;
        final FuncN<? extends R> zipFunction;
        final CompositeSubscription childSubscription = new CompositeSubscription();
        final AtomicLong counter = new AtomicLong(0L);

        public Zip(Observable[] os, Subscriber<? super R> observer, FuncN<? extends R> zipFunction) {
            this.os = os;
            this.observer = observer;
            this.zipFunction = zipFunction;
            this.observers = new Object[os.length];
            for (int i = 0; i < os.length; ++i) {
                InnerObserver io = new InnerObserver();
                this.observers[i] = io;
                this.childSubscription.add(io);
            }
            observer.add(this.childSubscription);
        }

        public void zip() {
            for (int i = 0; i < this.os.length; ++i) {
                this.os[i].unsafeSubscribe((InnerObserver)this.observers[i]);
            }
        }

        void tick() {
            if (this.counter.getAndIncrement() == 0L) {
                do {
                    int i;
                    Object[] vs = new Object[this.observers.length];
                    boolean allHaveValues = true;
                    block7: for (i = 0; i < this.observers.length; ++i) {
                        Object n = ((InnerObserver)this.observers[i]).items.peek();
                        if (n == null) {
                            allHaveValues = false;
                            continue;
                        }
                        switch (on.kind(n)) {
                            case OnNext: {
                                vs[i] = on.getValue(n);
                                continue block7;
                            }
                            case OnCompleted: {
                                this.observer.onCompleted();
                                this.childSubscription.unsubscribe();
                                return;
                            }
                        }
                    }
                    if (!allHaveValues) continue;
                    try {
                        this.observer.onNext(this.zipFunction.call(vs));
                    }
                    catch (Throwable e) {
                        this.observer.onError(OnErrorThrowable.addValueAsLastCause(e, vs));
                        return;
                    }
                    for (i = 0; i < this.observers.length; ++i) {
                        ((InnerObserver)this.observers[i]).items.poll();
                        if (!on.isCompleted(((InnerObserver)this.observers[i]).items.peek())) continue;
                        this.observer.onCompleted();
                        this.childSubscription.unsubscribe();
                        return;
                    }
                } while (this.counter.decrementAndGet() > 0L);
            }
        }

        final class InnerObserver
        extends Subscriber {
            final ConcurrentLinkedQueue items = new ConcurrentLinkedQueue();

            InnerObserver() {
            }

            @Override
            public void onCompleted() {
                this.items.add(on.completed());
                Zip.this.tick();
            }

            @Override
            public void onError(Throwable e) {
                Zip.this.observer.onError(e);
            }

            @Override
            public void onNext(Object t) {
                this.items.add(on.next(t));
                Zip.this.tick();
            }
        }
    }
}

