/*
 * Decompiled with CFR 0.152.
 */
package rx.plugins;

import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.operators.DebugSubscriber;
import rx.plugins.DebugNotification;
import rx.plugins.DebugNotificationListener;
import rx.plugins.RxJavaObservableExecutionHook;

public class DebugHook<C>
extends RxJavaObservableExecutionHook {
    private DebugNotificationListener<C> listener;

    public DebugHook(DebugNotificationListener<C> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The debug listener must not be null");
        }
        this.listener = listener;
    }

    @Override
    public <T> Observable.OnSubscribe<T> onSubscribeStart(final Observable<? extends T> observableInstance, final Observable.OnSubscribe<T> f) {
        return new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> o) {
                DebugNotification n = DebugNotification.createSubscribe(o, observableInstance, f);
                o = DebugHook.this.wrapOutbound(null, o);
                Object context = DebugHook.this.listener.start(n);
                try {
                    f.call(o);
                    DebugHook.this.listener.complete(context);
                }
                catch (Throwable e) {
                    DebugHook.this.listener.error(context, e);
                }
            }
        };
    }

    @Override
    public <T> Subscription onSubscribeReturn(Subscription subscription) {
        return subscription;
    }

    @Override
    public <T> Observable.OnSubscribe<T> onCreate(Observable.OnSubscribe<T> f) {
        return new DebugOnSubscribe(f);
    }

    @Override
    public <T, R> Observable.Operator<? extends R, ? super T> onLift(final Observable.Operator<? extends R, ? super T> bind) {
        return new Observable.Operator<R, T>(){

            @Override
            public Subscriber<? super T> call(Subscriber<? super R> o) {
                return DebugHook.this.wrapInbound(bind, (Subscriber)bind.call(DebugHook.this.wrapOutbound(bind, o)));
            }
        };
    }

    private <R> Subscriber<? super R> wrapOutbound(Observable.Operator<? extends R, ?> bind, Subscriber<? super R> o) {
        if (o instanceof DebugSubscriber) {
            if (bind != null) {
                ((DebugSubscriber)o).setFrom(bind);
            }
            return o;
        }
        return new DebugSubscriber<R, C>(this.listener, o, bind, null);
    }

    private <T> Subscriber<? super T> wrapInbound(Observable.Operator<?, ? super T> bind, Subscriber<? super T> o) {
        if (o instanceof DebugSubscriber) {
            if (bind != null) {
                ((DebugSubscriber)o).setTo(bind);
            }
            return o;
        }
        return new DebugSubscriber<T, C>(this.listener, o, null, bind);
    }

    public final class DebugOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        private final Observable.OnSubscribe<T> f;

        private DebugOnSubscribe(Observable.OnSubscribe<T> f) {
            this.f = f;
        }

        @Override
        public void call(Subscriber<? super T> o) {
            this.f.call(DebugHook.this.wrapInbound(null, o));
        }

        public Observable.OnSubscribe<T> getActual() {
            return this.f;
        }
    }
}

