/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.schedulers.GenericScheduledExecutorService;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.subscriptions.Subscriptions;

public class ExecutorScheduler
extends Scheduler {
    private final Executor executor;

    @Deprecated
    public ExecutorScheduler(Executor executor) {
        this.executor = executor;
    }

    @Deprecated
    public ExecutorScheduler(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public Subscription schedule(Action1<Scheduler.Inner> action) {
        InnerExecutorScheduler inner = new InnerExecutorScheduler();
        inner.schedule(action);
        return inner.innerSubscription;
    }

    @Override
    public Subscription schedule(Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
        InnerExecutorScheduler inner = new InnerExecutorScheduler();
        inner.schedule(action, delayTime, unit);
        return inner.innerSubscription;
    }

    @Override
    public Subscription schedulePeriodically(final Action1<Scheduler.Inner> action, long initialDelay, long period, TimeUnit unit) {
        if (this.executor instanceof ScheduledExecutorService) {
            final InnerExecutorScheduler inner = new InnerExecutorScheduler();
            ScheduledFuture<?> f = ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (inner.isUnsubscribed()) {
                        return;
                    }
                    action.call(inner);
                }
            }, initialDelay, period, unit);
            inner.innerSubscription.set(Subscriptions.from(f));
            return inner;
        }
        return super.schedulePeriodically(action, initialDelay, period, unit);
    }

    private class InnerExecutorScheduler
    extends Scheduler.Inner {
        private final MultipleAssignmentSubscription innerSubscription = new MultipleAssignmentSubscription();

        private InnerExecutorScheduler() {
        }

        @Override
        public void schedule(final Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
            if (this.innerSubscription.isUnsubscribed()) {
                return;
            }
            final InnerExecutorScheduler _inner = this;
            if (ExecutorScheduler.this.executor instanceof ScheduledExecutorService) {
                ScheduledFuture<?> f = ((ScheduledExecutorService)ExecutorScheduler.this.executor).schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (InnerExecutorScheduler.this.innerSubscription.isUnsubscribed()) {
                            return;
                        }
                        action.call(_inner);
                    }
                }, delayTime, unit);
                this.innerSubscription.set(Subscriptions.from(f));
            } else if (delayTime == 0L) {
                this.schedule(action);
            } else {
                ScheduledFuture<?> f = GenericScheduledExecutorService.getInstance().schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (InnerExecutorScheduler.this.innerSubscription.isUnsubscribed()) {
                            return;
                        }
                        InnerExecutorScheduler.this.schedule(action);
                    }
                }, delayTime, unit);
                this.innerSubscription.set(Subscriptions.from(f));
            }
        }

        @Override
        public void schedule(final Action1<Scheduler.Inner> action) {
            if (this.innerSubscription.isUnsubscribed()) {
                return;
            }
            final InnerExecutorScheduler _inner = this;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (InnerExecutorScheduler.this.innerSubscription.isUnsubscribed()) {
                        return;
                    }
                    action.call(_inner);
                }
            };
            if (ExecutorScheduler.this.executor instanceof ExecutorService) {
                Future<?> f = ((ExecutorService)ExecutorScheduler.this.executor).submit(r);
                this.innerSubscription.set(Subscriptions.from(f));
            } else {
                ExecutorScheduler.this.executor.execute(r);
            }
        }

        @Override
        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

