/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.schedulers.SleepingAction;
import rx.subscriptions.BooleanSubscription;

public final class ImmediateScheduler
extends Scheduler {
    private static final ImmediateScheduler INSTANCE = new ImmediateScheduler();

    @Deprecated
    public static ImmediateScheduler getInstance() {
        return INSTANCE;
    }

    static ImmediateScheduler instance() {
        return INSTANCE;
    }

    ImmediateScheduler() {
    }

    @Override
    public Subscription schedule(Action1<Scheduler.Inner> action) {
        InnerImmediateScheduler inner = new InnerImmediateScheduler();
        inner.schedule(action);
        return inner.innerSubscription;
    }

    @Override
    public Subscription schedule(Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
        InnerImmediateScheduler inner = new InnerImmediateScheduler();
        inner.schedule(action, delayTime, unit);
        return inner.innerSubscription;
    }

    private class InnerImmediateScheduler
    extends Scheduler.Inner
    implements Subscription {
        final BooleanSubscription innerSubscription = new BooleanSubscription();

        private InnerImmediateScheduler() {
        }

        @Override
        public void schedule(Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
            long execTime = this.now() + unit.toMillis(delayTime);
            this.schedule(new SleepingAction(action, ImmediateScheduler.this, execTime));
        }

        @Override
        public void schedule(Action1<Scheduler.Inner> action) {
            action.call(this);
        }

        @Override
        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

