/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.schedulers.GenericScheduledExecutorService;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public class NewThreadScheduler
extends Scheduler {
    private static final NewThreadScheduler INSTANCE = new NewThreadScheduler();
    private static final AtomicLong count = new AtomicLong();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "RxNewThreadScheduler-" + count.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    };

    @Deprecated
    public static NewThreadScheduler getInstance() {
        return INSTANCE;
    }

    static NewThreadScheduler instance() {
        return INSTANCE;
    }

    private NewThreadScheduler() {
    }

    @Override
    public Subscription schedule(Action1<Scheduler.Inner> action) {
        EventLoopScheduler innerScheduler = new EventLoopScheduler();
        innerScheduler.schedule(action);
        return innerScheduler.innerSubscription;
    }

    @Override
    public Subscription schedule(Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
        EventLoopScheduler innerScheduler = new EventLoopScheduler();
        innerScheduler.schedule(action, delayTime, unit);
        return innerScheduler.innerSubscription;
    }

    private class EventLoopScheduler
    extends Scheduler.Inner
    implements Subscription {
        private final CompositeSubscription innerSubscription = new CompositeSubscription();
        private final ExecutorService executor;
        private final Scheduler.Inner _inner = this;

        private EventLoopScheduler() {
            this.executor = Executors.newSingleThreadExecutor(THREAD_FACTORY);
        }

        @Override
        public void schedule(final Action1<Scheduler.Inner> action) {
            if (this.innerSubscription.isUnsubscribed()) {
                return;
            }
            final AtomicReference<Subscription> sf = new AtomicReference<Subscription>();
            Subscription s = Subscriptions.from(this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (EventLoopScheduler.this.innerSubscription.isUnsubscribed()) {
                            return;
                        }
                        action.call(EventLoopScheduler.this._inner);
                    }
                    finally {
                        Subscription s = (Subscription)sf.get();
                        if (s != null) {
                            EventLoopScheduler.this.innerSubscription.remove(s);
                        }
                    }
                }
            }));
            sf.set(s);
            this.innerSubscription.add(s);
        }

        @Override
        public void schedule(final Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
            final AtomicReference<Subscription> sf = new AtomicReference<Subscription>();
            ScheduledFuture<?> f = GenericScheduledExecutorService.getInstance().schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (EventLoopScheduler.this.innerSubscription.isUnsubscribed()) {
                            return;
                        }
                        EventLoopScheduler.this.schedule(action);
                    }
                    finally {
                        Subscription s = (Subscription)sf.get();
                        if (s != null) {
                            EventLoopScheduler.this.innerSubscription.remove(s);
                        }
                    }
                }
            }, delayTime, unit);
            Subscription s = Subscriptions.from(f);
            sf.set(s);
            this.innerSubscription.add(s);
        }

        @Override
        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

