/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import rx.Scheduler;
import rx.plugins.RxJavaPlugins;
import rx.schedulers.ExecutorScheduler;
import rx.schedulers.ImmediateScheduler;
import rx.schedulers.NewThreadScheduler;
import rx.schedulers.TestScheduler;
import rx.schedulers.TrampolineScheduler;

public class Schedulers {
    private final Scheduler computationScheduler;
    private final Scheduler ioScheduler;
    private final Scheduler newThreadScheduler;
    private static final Schedulers INSTANCE = new Schedulers();

    private Schedulers() {
        Scheduler c = RxJavaPlugins.getInstance().getDefaultSchedulers().getComputationScheduler();
        this.computationScheduler = c != null ? c : Schedulers.executor(Schedulers.createComputationExecutor());
        Scheduler io = RxJavaPlugins.getInstance().getDefaultSchedulers().getIOScheduler();
        this.ioScheduler = io != null ? io : Schedulers.executor(Schedulers.createIOExecutor());
        Scheduler nt = RxJavaPlugins.getInstance().getDefaultSchedulers().getNewThreadScheduler();
        this.newThreadScheduler = nt != null ? nt : NewThreadScheduler.instance();
    }

    public static Scheduler immediate() {
        return ImmediateScheduler.instance();
    }

    @Deprecated
    public static Scheduler currentThread() {
        return TrampolineScheduler.instance();
    }

    public static Scheduler trampoline() {
        return TrampolineScheduler.instance();
    }

    public static Scheduler newThread() {
        return Schedulers.INSTANCE.newThreadScheduler;
    }

    public static Scheduler executor(Executor executor) {
        return new ExecutorScheduler(executor);
    }

    public static Scheduler executor(ScheduledExecutorService executor) {
        return new ExecutorScheduler(executor);
    }

    @Deprecated
    public static Scheduler threadPoolForComputation() {
        return Schedulers.computation();
    }

    public static Scheduler computation() {
        return Schedulers.INSTANCE.computationScheduler;
    }

    @Deprecated
    public static Scheduler threadPoolForIO() {
        return Schedulers.io();
    }

    public static Scheduler io() {
        return Schedulers.INSTANCE.ioScheduler;
    }

    private static ScheduledExecutorService createComputationExecutor() {
        int cores = Runtime.getRuntime().availableProcessors();
        return Executors.newScheduledThreadPool(cores, new ThreadFactory(){
            final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "RxComputationThreadPool-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
    }

    private static Executor createIOExecutor() {
        ExecutorService result = Executors.newCachedThreadPool(new ThreadFactory(){
            final AtomicLong counter = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "RxIOThreadPool-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        return result;
    }

    public static TestScheduler test() {
        return new TestScheduler();
    }
}

