/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import rx.Scheduler;
import rx.functions.Action1;

class SleepingAction
implements Action1<Scheduler.Inner> {
    private final Action1<Scheduler.Inner> underlying;
    private final Scheduler scheduler;
    private final long execTime;

    public SleepingAction(Action1<Scheduler.Inner> underlying, Scheduler scheduler, long execTime) {
        this.underlying = underlying;
        this.scheduler = scheduler;
        this.execTime = execTime;
    }

    @Override
    public void call(Scheduler.Inner s) {
        long delay;
        if (s.isUnsubscribed()) {
            return;
        }
        if (this.execTime > this.scheduler.now() && (delay = this.execTime - this.scheduler.now()) > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        if (s.isUnsubscribed()) {
            return;
        }
        this.underlying.call(s);
    }
}

