/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.subscriptions.BooleanSubscription;

public class TestScheduler
extends Scheduler {
    private final Queue<TimedAction> queue = new PriorityQueue<TimedAction>(11, new CompareActionsByTime());
    private static long counter = 0L;
    private long time;

    @Override
    public long now() {
        return TimeUnit.NANOSECONDS.toMillis(this.time);
    }

    public void advanceTimeBy(long delayTime, TimeUnit unit) {
        this.advanceTimeTo(this.time + unit.toNanos(delayTime), TimeUnit.NANOSECONDS);
    }

    public void advanceTimeTo(long delayTime, TimeUnit unit) {
        long targetTime = unit.toNanos(delayTime);
        this.triggerActions(targetTime);
    }

    public void triggerActions() {
        this.triggerActions(this.time);
    }

    private void triggerActions(long targetTimeInNanos) {
        TimedAction current;
        while (!this.queue.isEmpty() && (current = this.queue.peek()).time <= targetTimeInNanos) {
            this.time = current.time;
            this.queue.remove();
            if (current.scheduler.isUnsubscribed()) continue;
            current.action.call(current.scheduler);
        }
        this.time = targetTimeInNanos;
    }

    public Scheduler.Inner createInnerScheduler() {
        return new InnerTestScheduler();
    }

    @Override
    public Subscription schedule(Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
        Scheduler.Inner inner = this.createInnerScheduler();
        TimedAction timedAction = new TimedAction(inner, this.time + unit.toNanos(delayTime), action);
        this.queue.add(timedAction);
        return inner;
    }

    @Override
    public Subscription schedule(Action1<Scheduler.Inner> action) {
        Scheduler.Inner inner = this.createInnerScheduler();
        TimedAction timedAction = new TimedAction(inner, 0L, action);
        this.queue.add(timedAction);
        return inner;
    }

    static /* synthetic */ long access$108() {
        return counter++;
    }

    private final class InnerTestScheduler
    extends Scheduler.Inner {
        private BooleanSubscription s = new BooleanSubscription();

        private InnerTestScheduler() {
        }

        @Override
        public void unsubscribe() {
            this.s.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.s.isUnsubscribed();
        }

        @Override
        public void schedule(Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
            TimedAction timedAction = new TimedAction(this, TestScheduler.this.time + unit.toNanos(delayTime), action);
            TestScheduler.this.queue.add(timedAction);
        }

        @Override
        public void schedule(Action1<Scheduler.Inner> action) {
            TimedAction timedAction = new TimedAction(this, 0L, action);
            TestScheduler.this.queue.add(timedAction);
        }
    }

    private static class CompareActionsByTime
    implements Comparator<TimedAction> {
        private CompareActionsByTime() {
        }

        @Override
        public int compare(TimedAction action1, TimedAction action2) {
            if (action1.time == action2.time) {
                return Long.valueOf(action1.count).compareTo(action2.count);
            }
            return Long.valueOf(action1.time).compareTo(action2.time);
        }
    }

    private static class TimedAction {
        private final long time;
        private final Action1<Scheduler.Inner> action;
        private final Scheduler.Inner scheduler;
        private final long count = TestScheduler.access$108();

        private TimedAction(Scheduler.Inner scheduler, long time, Action1<Scheduler.Inner> action) {
            this.time = time;
            this.action = action;
            this.scheduler = scheduler;
        }

        public String toString() {
            return String.format("TimedAction(time = %d, action = %s)", this.time, this.action.toString());
        }
    }
}

