/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.schedulers.SleepingAction;
import rx.subscriptions.BooleanSubscription;

public class TrampolineScheduler
extends Scheduler {
    private static final TrampolineScheduler INSTANCE = new TrampolineScheduler();
    private static final ThreadLocal<PriorityQueue<TimedAction>> QUEUE = new ThreadLocal();
    private final AtomicInteger counter = new AtomicInteger(0);

    @Deprecated
    public static TrampolineScheduler getInstance() {
        return INSTANCE;
    }

    static TrampolineScheduler instance() {
        return INSTANCE;
    }

    @Override
    public Subscription schedule(Action1<Scheduler.Inner> action) {
        InnerCurrentThreadScheduler inner = new InnerCurrentThreadScheduler();
        inner.schedule(action);
        return inner.innerSubscription;
    }

    @Override
    public Subscription schedule(Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
        InnerCurrentThreadScheduler inner = new InnerCurrentThreadScheduler();
        inner.schedule(action, delayTime, unit);
        return inner.innerSubscription;
    }

    TrampolineScheduler() {
    }

    private static class TimedAction
    implements Comparable<TimedAction> {
        final Action1<Scheduler.Inner> action;
        final Long execTime;
        final Integer count;

        private TimedAction(Action1<Scheduler.Inner> action, Long execTime, Integer count) {
            this.action = action;
            this.execTime = execTime;
            this.count = count;
        }

        @Override
        public int compareTo(TimedAction that) {
            int result = this.execTime.compareTo(that.execTime);
            if (result == 0) {
                return this.count.compareTo(that.count);
            }
            return result;
        }
    }

    private class InnerCurrentThreadScheduler
    extends Scheduler.Inner
    implements Subscription {
        private final BooleanSubscription innerSubscription = new BooleanSubscription();

        private InnerCurrentThreadScheduler() {
        }

        @Override
        public void schedule(Action1<Scheduler.Inner> action) {
            this.enqueue(action, this.now());
        }

        @Override
        public void schedule(Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
            long execTime = this.now() + unit.toMillis(delayTime);
            this.enqueue(new SleepingAction(action, TrampolineScheduler.this, execTime), execTime);
        }

        private void enqueue(Action1<Scheduler.Inner> action, long execTime) {
            boolean exec;
            if (this.innerSubscription.isUnsubscribed()) {
                return;
            }
            PriorityQueue<TimedAction> queue = (PriorityQueue<TimedAction>)QUEUE.get();
            boolean bl = exec = queue == null;
            if (exec) {
                queue = new PriorityQueue<TimedAction>();
                QUEUE.set(queue);
            }
            queue.add(new TimedAction(action, execTime, TrampolineScheduler.this.counter.incrementAndGet()));
            if (exec) {
                while (!queue.isEmpty()) {
                    if (this.innerSubscription.isUnsubscribed()) {
                        return;
                    }
                    ((TimedAction)queue.poll()).action.call(this);
                }
                QUEUE.set(null);
            }
        }

        @Override
        public void unsubscribe() {
            QUEUE.set(null);
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

