/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class AsyncSubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> subscriptionManager;
    final AtomicReference<Notification<T>> lastNotification;

    public static <T> AsyncSubject<T> create() {
        SubjectSubscriptionManager subscriptionManager = new SubjectSubscriptionManager();
        final AtomicReference lastNotification = new AtomicReference(new Notification());
        Observable.OnSubscribe onSubscribe = subscriptionManager.getOnSubscribeFunc(new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
            }
        }, new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                AsyncSubject.emitValueToObserver((Notification)lastNotification.get(), o);
            }
        }, null);
        return new AsyncSubject(onSubscribe, subscriptionManager, lastNotification);
    }

    protected static <T> void emitValueToObserver(Notification<T> n, Observer<? super T> o) {
        n.accept(o);
        if (n.isOnNext()) {
            o.onCompleted();
        }
    }

    protected AsyncSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> subscriptionManager, AtomicReference<Notification<T>> lastNotification) {
        super(onSubscribe);
        this.subscriptionManager = subscriptionManager;
        this.lastNotification = lastNotification;
    }

    @Override
    public void onCompleted() {
        Collection<SubjectSubscriptionManager.SubjectObserver<T>> observers = this.subscriptionManager.terminate(new Action0(){

            @Override
            public void call() {
            }
        });
        if (observers != null) {
            for (Observer observer : observers) {
                AsyncSubject.emitValueToObserver(this.lastNotification.get(), observer);
            }
        }
    }

    @Override
    public void onError(final Throwable e) {
        Collection<SubjectSubscriptionManager.SubjectObserver<T>> observers = this.subscriptionManager.terminate(new Action0(){

            @Override
            public void call() {
                AsyncSubject.this.lastNotification.set(Notification.createOnError(e));
            }
        });
        if (observers != null) {
            for (Observer observer : observers) {
                AsyncSubject.emitValueToObserver(this.lastNotification.get(), observer);
            }
        }
    }

    @Override
    public void onNext(T v) {
        this.lastNotification.set(Notification.createOnNext(v));
    }
}

