/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.schedulers.TestScheduler;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class TestSubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> subscriptionManager;
    private final AtomicReference<Notification<T>> lastNotification;
    private final Scheduler.Inner innerScheduler;

    public static <T> TestSubject<T> create(TestScheduler scheduler) {
        SubjectSubscriptionManager subscriptionManager = new SubjectSubscriptionManager();
        final AtomicReference<Notification<T>> lastNotification = new AtomicReference<Notification<T>>();
        Observable.OnSubscribe onSubscribe = subscriptionManager.getOnSubscribeFunc(new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
            }
        }, new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                ((Notification)lastNotification.get()).accept(o);
            }
        }, null);
        return new TestSubject(onSubscribe, subscriptionManager, lastNotification, scheduler);
    }

    protected TestSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> subscriptionManager, AtomicReference<Notification<T>> lastNotification, TestScheduler scheduler) {
        super(onSubscribe);
        this.subscriptionManager = subscriptionManager;
        this.lastNotification = lastNotification;
        this.innerScheduler = scheduler.createInnerScheduler();
    }

    @Override
    public void onCompleted() {
        this.onCompleted(this.innerScheduler.now());
    }

    private void _onCompleted() {
        Collection<SubjectSubscriptionManager.SubjectObserver<T>> observers = this.subscriptionManager.terminate(new Action0(){

            @Override
            public void call() {
                TestSubject.this.lastNotification.set(Notification.createOnCompleted());
            }
        });
        if (observers != null) {
            for (Observer observer : observers) {
                observer.onCompleted();
            }
        }
    }

    public void onCompleted(long timeInMilliseconds) {
        this.innerScheduler.schedule(new Action1<Scheduler.Inner>(){

            @Override
            public void call(Scheduler.Inner t1) {
                TestSubject.this._onCompleted();
            }
        }, timeInMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onError(Throwable e) {
        this.onError(e, this.innerScheduler.now());
    }

    private void _onError(final Throwable e) {
        Collection<SubjectSubscriptionManager.SubjectObserver<T>> observers = this.subscriptionManager.terminate(new Action0(){

            @Override
            public void call() {
                TestSubject.this.lastNotification.set(Notification.createOnError(e));
            }
        });
        if (observers != null) {
            for (Observer observer : observers) {
                observer.onError(e);
            }
        }
    }

    public void onError(final Throwable e, long timeInMilliseconds) {
        this.innerScheduler.schedule(new Action1<Scheduler.Inner>(){

            @Override
            public void call(Scheduler.Inner t1) {
                TestSubject.this._onError(e);
            }
        }, timeInMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onNext(T v) {
        this.onNext(v, this.innerScheduler.now());
    }

    private void _onNext(T v) {
        for (SubjectSubscriptionManager.SubjectObserver<Object> o : this.subscriptionManager.rawSnapshot()) {
            o.onNext(v);
        }
    }

    public void onNext(final T v, long timeInMilliseconds) {
        this.innerScheduler.schedule(new Action1<Scheduler.Inner>(){

            @Override
            public void call(Scheduler.Inner t1) {
                TestSubject.this._onNext(v);
            }
        }, timeInMilliseconds, TimeUnit.MILLISECONDS);
    }
}

