/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public final class RefCountSubscription
implements Subscription {
    private final Subscription actual;
    private final AtomicReference<State> state = new AtomicReference<State>(new State(false, 0));

    public RefCountSubscription(Subscription s) {
        if (s == null) {
            throw new IllegalArgumentException("s");
        }
        this.actual = s;
    }

    @Deprecated
    public Subscription getSubscription() {
        return this.get();
    }

    public Subscription get() {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            return Subscriptions.empty();
        } while (!this.state.compareAndSet(oldState, newState = oldState.addChild()));
        return new InnerSubscription();
    }

    @Override
    public boolean isUnsubscribed() {
        return this.state.get().isUnsubscribed;
    }

    @Override
    public void unsubscribe() {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.unsubscribe()));
        this.unsubscribeActualIfApplicable(newState);
    }

    private void unsubscribeActualIfApplicable(State state) {
        if (state.isUnsubscribed && state.children == 0) {
            this.actual.unsubscribe();
        }
    }

    private final class InnerSubscription
    implements Subscription {
        final AtomicBoolean innerDone = new AtomicBoolean();

        private InnerSubscription() {
        }

        @Override
        public void unsubscribe() {
            if (this.innerDone.compareAndSet(false, true)) {
                State newState;
                State oldState;
                do {
                    oldState = (State)RefCountSubscription.this.state.get();
                    newState = oldState.removeChild();
                } while (!RefCountSubscription.this.state.compareAndSet(oldState, newState));
                RefCountSubscription.this.unsubscribeActualIfApplicable(newState);
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerDone.get();
        }
    }

    private static final class State {
        final boolean isUnsubscribed;
        final int children;

        State(boolean u, int c) {
            this.isUnsubscribed = u;
            this.children = c;
        }

        State addChild() {
            return new State(this.isUnsubscribed, this.children + 1);
        }

        State removeChild() {
            return new State(this.isUnsubscribed, this.children - 1);
        }

        State unsubscribe() {
            return new State(true, this.children);
        }
    }
}

