/*
 * Decompiled with CFR 0.152.
 */
package rx.util.async;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Action3;
import rx.functions.Action4;
import rx.functions.Action5;
import rx.functions.Action6;
import rx.functions.Action7;
import rx.functions.Action8;
import rx.functions.Action9;
import rx.functions.ActionN;
import rx.functions.Actions;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.functions.Func5;
import rx.functions.Func6;
import rx.functions.Func7;
import rx.functions.Func8;
import rx.functions.Func9;
import rx.functions.FuncN;
import rx.schedulers.Schedulers;
import rx.subjects.AsyncSubject;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;
import rx.subscriptions.SerialSubscription;
import rx.util.async.StoppableObservable;
import rx.util.async.operators.Functionals;
import rx.util.async.operators.OperationDeferFuture;
import rx.util.async.operators.OperationForEachFuture;
import rx.util.async.operators.OperationFromFunctionals;
import rx.util.async.operators.OperationStartFuture;

public final class Async {
    private Async() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Observable<T> start(Func0<T> func) {
        return Async.toAsync(func).call();
    }

    public static <T> Observable<T> start(Func0<T> func, Scheduler scheduler) {
        return Async.toAsync(func, scheduler).call();
    }

    public static Func0<Observable<Void>> toAsync(Action0 action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <R> Func0<Observable<R>> toAsync(Func0<? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static <T1> Func1<T1, Observable<Void>> toAsync(Action1<? super T1> action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <T1, R> Func1<T1, Observable<R>> toAsync(Func1<? super T1, ? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static <T1, T2> Func2<T1, T2, Observable<Void>> toAsync(Action2<? super T1, ? super T2> action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <T1, T2, R> Func2<T1, T2, Observable<R>> toAsync(Func2<? super T1, ? super T2, ? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static <T1, T2, T3> Func3<T1, T2, T3, Observable<Void>> toAsync(Action3<? super T1, ? super T2, ? super T3> action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <T1, T2, T3, R> Func3<T1, T2, T3, Observable<R>> toAsync(Func3<? super T1, ? super T2, ? super T3, ? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static <T1, T2, T3, T4> Func4<T1, T2, T3, T4, Observable<Void>> toAsync(Action4<? super T1, ? super T2, ? super T3, ? super T4> action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, R> Func4<T1, T2, T3, T4, Observable<R>> toAsync(Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, T5> Func5<T1, T2, T3, T4, T5, Observable<Void>> toAsync(Action5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5> action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, T5, R> Func5<T1, T2, T3, T4, T5, Observable<R>> toAsync(Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, T5, T6> Func6<T1, T2, T3, T4, T5, T6, Observable<Void>> toAsync(Action6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6> action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, T5, T6, R> Func6<T1, T2, T3, T4, T5, T6, Observable<R>> toAsync(Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Func7<T1, T2, T3, T4, T5, T6, T7, Observable<Void>> toAsync(Action7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7> action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Func7<T1, T2, T3, T4, T5, T6, T7, Observable<R>> toAsync(Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Func8<T1, T2, T3, T4, T5, T6, T7, T8, Observable<Void>> toAsync(Action8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8> action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Func8<T1, T2, T3, T4, T5, T6, T7, T8, Observable<R>> toAsync(Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Func9<T1, T2, T3, T4, T5, T6, T7, T8, T9, Observable<Void>> toAsync(Action9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9> action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Func9<T1, T2, T3, T4, T5, T6, T7, T8, T9, Observable<R>> toAsync(Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static FuncN<Observable<Void>> toAsync(ActionN action) {
        return Async.toAsync(action, Schedulers.computation());
    }

    public static <R> FuncN<Observable<R>> toAsync(FuncN<? extends R> func) {
        return Async.toAsync(func, Schedulers.computation());
    }

    public static Func0<Observable<Void>> toAsync(Action0 action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <R> Func0<Observable<R>> toAsync(final Func0<? extends R> func, final Scheduler scheduler) {
        return new Func0<Observable<R>>(){

            @Override
            public Observable<R> call() {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call();
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static <T1> Func1<T1, Observable<Void>> toAsync(Action1<? super T1> action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <T1, R> Func1<T1, Observable<R>> toAsync(final Func1<? super T1, ? extends R> func, final Scheduler scheduler) {
        return new Func1<T1, Observable<R>>(){

            @Override
            public Observable<R> call(final T1 t1) {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call(t1);
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static <T1, T2> Func2<T1, T2, Observable<Void>> toAsync(Action2<? super T1, ? super T2> action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <T1, T2, R> Func2<T1, T2, Observable<R>> toAsync(final Func2<? super T1, ? super T2, ? extends R> func, final Scheduler scheduler) {
        return new Func2<T1, T2, Observable<R>>(){

            @Override
            public Observable<R> call(final T1 t1, final T2 t2) {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call(t1, t2);
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static <T1, T2, T3> Func3<T1, T2, T3, Observable<Void>> toAsync(Action3<? super T1, ? super T2, ? super T3> action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <T1, T2, T3, R> Func3<T1, T2, T3, Observable<R>> toAsync(final Func3<? super T1, ? super T2, ? super T3, ? extends R> func, final Scheduler scheduler) {
        return new Func3<T1, T2, T3, Observable<R>>(){

            @Override
            public Observable<R> call(final T1 t1, final T2 t2, final T3 t3) {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call(t1, t2, t3);
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static <T1, T2, T3, T4> Func4<T1, T2, T3, T4, Observable<Void>> toAsync(Action4<? super T1, ? super T2, ? super T3, ? super T4> action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <T1, T2, T3, T4, R> Func4<T1, T2, T3, T4, Observable<R>> toAsync(final Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> func, final Scheduler scheduler) {
        return new Func4<T1, T2, T3, T4, Observable<R>>(){

            @Override
            public Observable<R> call(final T1 t1, final T2 t2, final T3 t3, final T4 t4) {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call(t1, t2, t3, t4);
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static <T1, T2, T3, T4, T5> Func5<T1, T2, T3, T4, T5, Observable<Void>> toAsync(Action5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5> action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <T1, T2, T3, T4, T5, R> Func5<T1, T2, T3, T4, T5, Observable<R>> toAsync(final Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> func, final Scheduler scheduler) {
        return new Func5<T1, T2, T3, T4, T5, Observable<R>>(){

            @Override
            public Observable<R> call(final T1 t1, final T2 t2, final T3 t3, final T4 t4, final T5 t5) {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call(t1, t2, t3, t4, t5);
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static <T1, T2, T3, T4, T5, T6> Func6<T1, T2, T3, T4, T5, T6, Observable<Void>> toAsync(Action6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6> action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <T1, T2, T3, T4, T5, T6, R> Func6<T1, T2, T3, T4, T5, T6, Observable<R>> toAsync(final Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> func, final Scheduler scheduler) {
        return new Func6<T1, T2, T3, T4, T5, T6, Observable<R>>(){

            @Override
            public Observable<R> call(final T1 t1, final T2 t2, final T3 t3, final T4 t4, final T5 t5, final T6 t6) {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call(t1, t2, t3, t4, t5, t6);
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Func7<T1, T2, T3, T4, T5, T6, T7, Observable<Void>> toAsync(Action7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7> action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Func7<T1, T2, T3, T4, T5, T6, T7, Observable<R>> toAsync(final Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> func, final Scheduler scheduler) {
        return new Func7<T1, T2, T3, T4, T5, T6, T7, Observable<R>>(){

            @Override
            public Observable<R> call(final T1 t1, final T2 t2, final T3 t3, final T4 t4, final T5 t5, final T6 t6, final T7 t7) {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call(t1, t2, t3, t4, t5, t6, t7);
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Func8<T1, T2, T3, T4, T5, T6, T7, T8, Observable<Void>> toAsync(Action8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8> action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Func8<T1, T2, T3, T4, T5, T6, T7, T8, Observable<R>> toAsync(final Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> func, final Scheduler scheduler) {
        return new Func8<T1, T2, T3, T4, T5, T6, T7, T8, Observable<R>>(){

            @Override
            public Observable<R> call(final T1 t1, final T2 t2, final T3 t3, final T4 t4, final T5 t5, final T6 t6, final T7 t7, final T8 t8) {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call(t1, t2, t3, t4, t5, t6, t7, t8);
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Func9<T1, T2, T3, T4, T5, T6, T7, T8, T9, Observable<Void>> toAsync(Action9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9> action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Func9<T1, T2, T3, T4, T5, T6, T7, T8, T9, Observable<R>> toAsync(final Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> func, final Scheduler scheduler) {
        return new Func9<T1, T2, T3, T4, T5, T6, T7, T8, T9, Observable<R>>(){

            @Override
            public Observable<R> call(final T1 t1, final T2 t2, final T3 t3, final T4 t4, final T5 t5, final T6 t6, final T7 t7, final T8 t8, final T9 t9) {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call(t1, t2, t3, t4, t5, t6, t7, t8, t9);
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static FuncN<Observable<Void>> toAsync(ActionN action, Scheduler scheduler) {
        return Async.toAsync(Actions.toFunc(action), scheduler);
    }

    public static <R> FuncN<Observable<R>> toAsync(final FuncN<? extends R> func, final Scheduler scheduler) {
        return new FuncN<Observable<R>>(){

            @Override
            public Observable<R> call(final Object ... args) {
                final AsyncSubject subject = AsyncSubject.create();
                scheduler.schedule(new Action1<Scheduler.Inner>(){

                    @Override
                    public void call(Scheduler.Inner inner) {
                        Object result;
                        try {
                            result = func.call(args);
                        }
                        catch (Throwable t) {
                            subject.onError(t);
                            return;
                        }
                        subject.onNext(result);
                        subject.onCompleted();
                    }
                });
                return subject;
            }
        };
    }

    public static FuncN<Observable<Void>> asyncAction(ActionN action) {
        return Async.toAsync(action);
    }

    public static FuncN<Observable<Void>> asyncAction(ActionN action, Scheduler scheduler) {
        return Async.toAsync(action, scheduler);
    }

    public static <R> FuncN<Observable<R>> asyncFunc(FuncN<? extends R> func) {
        return Async.toAsync(func);
    }

    public static <R> FuncN<Observable<R>> asyncFunc(FuncN<? extends R> func, Scheduler scheduler) {
        return Async.toAsync(func, scheduler);
    }

    public static <T> Observable<T> startFuture(Func0<? extends Future<? extends T>> functionAsync) {
        return OperationStartFuture.startFuture(functionAsync);
    }

    public static <T> Observable<T> startFuture(Func0<? extends Future<? extends T>> functionAsync, Scheduler scheduler) {
        return OperationStartFuture.startFuture(functionAsync, scheduler);
    }

    public static <T> Observable<T> deferFuture(Func0<? extends Future<? extends Observable<? extends T>>> observableFactoryAsync) {
        return OperationDeferFuture.deferFuture(observableFactoryAsync);
    }

    public static <T> Observable<T> deferFuture(Func0<? extends Future<? extends Observable<? extends T>>> observableFactoryAsync, Scheduler scheduler) {
        return OperationDeferFuture.deferFuture(observableFactoryAsync, scheduler);
    }

    public static <T> FutureTask<Void> forEachFuture(Observable<? extends T> source, Action1<? super T> onNext) {
        return OperationForEachFuture.forEachFuture(source, onNext);
    }

    public static <T> FutureTask<Void> forEachFuture(Observable<? extends T> source, Action1<? super T> onNext, Action1<? super Throwable> onError) {
        return OperationForEachFuture.forEachFuture(source, onNext, onError);
    }

    public static <T> FutureTask<Void> forEachFuture(Observable<? extends T> source, Action1<? super T> onNext, Action1<? super Throwable> onError, Action0 onCompleted) {
        return OperationForEachFuture.forEachFuture(source, onNext, onError, onCompleted);
    }

    public static <T> FutureTask<Void> forEachFuture(Observable<? extends T> source, Action1<? super T> onNext, Scheduler scheduler) {
        FutureTask<Void> task = OperationForEachFuture.forEachFuture(source, onNext);
        scheduler.schedule(Functionals.fromRunnable(task));
        return task;
    }

    public static <T> FutureTask<Void> forEachFuture(Observable<? extends T> source, Action1<? super T> onNext, Action1<? super Throwable> onError, Scheduler scheduler) {
        FutureTask<Void> task = OperationForEachFuture.forEachFuture(source, onNext, onError);
        scheduler.schedule(Functionals.fromRunnable(task));
        return task;
    }

    public static <T> FutureTask<Void> forEachFuture(Observable<? extends T> source, Action1<? super T> onNext, Action1<? super Throwable> onError, Action0 onCompleted, Scheduler scheduler) {
        FutureTask<Void> task = OperationForEachFuture.forEachFuture(source, onNext, onError, onCompleted);
        scheduler.schedule(Functionals.fromRunnable(task));
        return task;
    }

    public static <R> Observable<R> fromAction(Action0 action, R result) {
        return Async.fromAction(action, result, Schedulers.computation());
    }

    @Deprecated
    public static <R> Observable<R> fromFunc0(Func0<? extends R> function) {
        return Async.fromCallable(function);
    }

    public static <R> Observable<R> fromCallable(Callable<? extends R> callable) {
        return Async.fromCallable(callable, Schedulers.computation());
    }

    public static <R> Observable<R> fromRunnable(Runnable run, R result) {
        return Async.fromRunnable(run, result, Schedulers.computation());
    }

    public static <R> Observable<R> fromAction(Action0 action, R result, Scheduler scheduler) {
        return Observable.create(OperationFromFunctionals.fromAction(action, result)).subscribeOn(scheduler);
    }

    @Deprecated
    public static <R> Observable<R> fromFunc0(Func0<? extends R> function, Scheduler scheduler) {
        return Async.fromCallable(function, scheduler);
    }

    public static <R> Observable<R> fromCallable(Callable<? extends R> callable, Scheduler scheduler) {
        return Observable.create(OperationFromFunctionals.fromCallable(callable)).subscribeOn(scheduler);
    }

    public static <R> Observable<R> fromRunnable(Runnable run, R result, Scheduler scheduler) {
        return Observable.create(OperationFromFunctionals.fromRunnable(run, result)).subscribeOn(scheduler);
    }

    public static <T> StoppableObservable<T> runAsync(Scheduler scheduler, Action2<? super Observer<? super T>, ? super Subscription> action) {
        return Async.runAsync(scheduler, PublishSubject.create(), action);
    }

    public static <T, U> StoppableObservable<U> runAsync(Scheduler scheduler, final Subject<T, U> subject, final Action2<? super Observer<? super T>, ? super Subscription> action) {
        final SerialSubscription csub = new SerialSubscription();
        StoppableObservable co = new StoppableObservable(new Observable.OnSubscribe<U>(){

            @Override
            public void call(Subscriber<? super U> t1) {
                subject.subscribe(t1);
            }
        }, csub);
        csub.set(scheduler.schedule(new Action1<Scheduler.Inner>(){

            @Override
            public void call(Scheduler.Inner t1) {
                if (!csub.isUnsubscribed()) {
                    action.call(subject, csub);
                }
            }
        }));
        return co;
    }
}

