/*
 * Decompiled with CFR 0.152.
 */
package rx.util.async.operators;

import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Action1;

public final class Functionals {
    private static final Action1<Throwable> EMPTY_THROWABLE = new EmptyThrowable();
    private static final Action0 EMPTY = new EmptyAction();

    private Functionals() {
        throw new IllegalStateException("No instances!");
    }

    public static Action1<Throwable> emptyThrowable() {
        return EMPTY_THROWABLE;
    }

    public static Action0 empty() {
        return EMPTY;
    }

    public static Action1<Scheduler.Inner> fromRunnable(Runnable run) {
        if (run == null) {
            throw new NullPointerException("run");
        }
        return new ActionWrappingRunnable(run);
    }

    public static Runnable toRunnable(Action0 action) {
        if (action == null) {
            throw new NullPointerException("action");
        }
        return new RunnableAction(action);
    }

    private static final class RunnableAction
    implements Runnable {
        final Action0 action;

        public RunnableAction(Action0 action) {
            this.action = action;
        }

        @Override
        public void run() {
            this.action.call();
        }
    }

    private static final class ActionWrappingRunnable
    implements Action1<Scheduler.Inner> {
        final Runnable run;

        public ActionWrappingRunnable(Runnable run) {
            this.run = run;
        }

        @Override
        public void call(Scheduler.Inner inner) {
            this.run.run();
        }
    }

    private static final class EmptyAction
    implements Action0 {
        private EmptyAction() {
        }

        @Override
        public void call() {
        }
    }

    private static final class EmptyThrowable
    implements Action1<Throwable> {
        private EmptyThrowable() {
        }

        @Override
        public void call(Throwable t1) {
        }
    }
}

