/*
 * Decompiled with CFR 0.152.
 */
package rx.util.async.operators;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.util.async.operators.Functionals;

abstract class LatchedObserver<T>
implements Observer<T> {
    protected final CountDownLatch latch;
    protected volatile Throwable error;
    protected final AtomicBoolean done;

    public LatchedObserver(CountDownLatch latch) {
        this.latch = latch;
        this.done = new AtomicBoolean();
    }

    protected abstract void onNextCore(T var1);

    protected abstract void onErrorCore(Throwable var1);

    protected abstract void onCompletedCore();

    protected boolean fail(Throwable e) {
        if (this.done.compareAndSet(false, true)) {
            this.onErrorCore(e);
            return true;
        }
        return false;
    }

    @Override
    public final void onNext(T args) {
        if (!this.done.get()) {
            this.onNextCore(args);
        }
    }

    @Override
    public final void onError(Throwable e) {
        this.fail(e);
    }

    @Override
    public final void onCompleted() {
        if (this.done.compareAndSet(false, true)) {
            this.onCompletedCore();
        }
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.latch.await(time, unit);
    }

    public Throwable getThrowable() {
        return this.error;
    }

    public static <T> LatchedObserver<T> create(Action1<? super T> onNext) {
        return LatchedObserver.create(onNext, new CountDownLatch(1));
    }

    public static <T> LatchedObserver<T> create(Action1<? super T> onNext, Action1<? super Throwable> onError) {
        return LatchedObserver.create(onNext, onError, new CountDownLatch(1));
    }

    public static <T> LatchedObserver<T> create(Action1<? super T> onNext, Action1<? super Throwable> onError, Action0 onCompleted) {
        return LatchedObserver.create(onNext, onError, onCompleted, new CountDownLatch(1));
    }

    public static <T> LatchedObserver<T> create(Action1<? super T> onNext, CountDownLatch latch) {
        return new LatchedObserverImpl<T>(onNext, Functionals.emptyThrowable(), Functionals.empty(), latch);
    }

    public static <T> LatchedObserver<T> create(Action1<? super T> onNext, Action1<? super Throwable> onError, CountDownLatch latch) {
        return new LatchedObserverImpl<T>(onNext, onError, Functionals.empty(), latch);
    }

    public static <T> LatchedObserver<T> create(Action1<? super T> onNext, Action1<? super Throwable> onError, Action0 onCompleted, CountDownLatch latch) {
        return new LatchedObserverImpl<T>(onNext, onError, onCompleted, latch);
    }

    public static <T> LatchedObserver<T> createIndexed(Action2<? super T, ? super Integer> onNext) {
        return LatchedObserver.createIndexed(onNext, new CountDownLatch(1));
    }

    public static <T> LatchedObserver<T> createIndexed(Action2<? super T, ? super Integer> onNext, Action1<? super Throwable> onError) {
        return LatchedObserver.createIndexed(onNext, onError, new CountDownLatch(1));
    }

    public static <T> LatchedObserver<T> createIndexed(Action2<? super T, ? super Integer> onNext, Action1<? super Throwable> onError, Action0 onCompleted) {
        return LatchedObserver.createIndexed(onNext, onError, onCompleted, new CountDownLatch(1));
    }

    public static <T> LatchedObserver<T> createIndexed(Action2<? super T, ? super Integer> onNext, CountDownLatch latch) {
        return new LatchedObserverIndexedImpl<T>(onNext, Functionals.emptyThrowable(), Functionals.empty(), latch);
    }

    public static <T> LatchedObserver<T> createIndexed(Action2<? super T, ? super Integer> onNext, Action1<? super Throwable> onError, CountDownLatch latch) {
        return new LatchedObserverIndexedImpl<T>(onNext, onError, Functionals.empty(), latch);
    }

    public static <T> LatchedObserver<T> createIndexed(Action2<? super T, ? super Integer> onNext, Action1<? super Throwable> onError, Action0 onCompleted, CountDownLatch latch) {
        return new LatchedObserverIndexedImpl<T>(onNext, onError, onCompleted, latch);
    }

    private static final class LatchedObserverIndexedImpl<T>
    extends LatchedObserver<T> {
        final Action2<? super T, ? super Integer> onNext;
        final Action1<? super Throwable> onError;
        final Action0 onCompleted;
        int index;

        public LatchedObserverIndexedImpl(Action2<? super T, ? super Integer> onNext, Action1<? super Throwable> onError, Action0 onCompleted, CountDownLatch latch) {
            super(latch);
            this.onNext = onNext;
            this.onError = onError;
            this.onCompleted = onCompleted;
        }

        @Override
        protected void onNextCore(T args) {
            if (this.index == Integer.MAX_VALUE) {
                this.fail(new ArithmeticException("index overflow"));
                return;
            }
            try {
                this.onNext.call(args, this.index++);
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onErrorCore(Throwable e) {
            try {
                this.error = e;
                this.onError.call(e);
            }
            finally {
                this.latch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCompletedCore() {
            try {
                this.onCompleted.call();
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    private static final class LatchedObserverImpl<T>
    extends LatchedObserver<T> {
        final Action1<? super T> onNext;
        final Action1<? super Throwable> onError;
        final Action0 onCompleted;

        public LatchedObserverImpl(Action1<? super T> onNext, Action1<? super Throwable> onError, Action0 onCompleted, CountDownLatch latch) {
            super(latch);
            this.onNext = onNext;
            this.onError = onError;
            this.onCompleted = onCompleted;
        }

        @Override
        protected void onNextCore(T args) {
            try {
                this.onNext.call(args);
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onErrorCore(Throwable e) {
            try {
                this.error = e;
                this.onError.call(e);
            }
            finally {
                this.latch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCompletedCore() {
            try {
                this.onCompleted.call();
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

