/*
 * Decompiled with CFR 0.152.
 */
package rx.util.async.operators;

import java.util.concurrent.Callable;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Actions;
import rx.functions.Func0;
import rx.subscriptions.Subscriptions;

public final class OperationFromFunctionals {
    private OperationFromFunctionals() {
        throw new IllegalStateException("No instances!");
    }

    public static <R> Observable.OnSubscribeFunc<R> fromAction(Action0 action, R result) {
        return new InvokeAsync<R>(Actions.toFunc(action, result));
    }

    @Deprecated
    public static <R> Observable.OnSubscribeFunc<R> fromFunc0(Func0<? extends R> function) {
        return OperationFromFunctionals.fromCallable(function);
    }

    public static <R> Observable.OnSubscribeFunc<R> fromCallable(Callable<? extends R> callable) {
        return new InvokeAsync<R>(callable);
    }

    public static <R> Observable.OnSubscribeFunc<R> fromRunnable(final Runnable run, final R result) {
        return new InvokeAsync(new Func0<R>(){

            @Override
            public R call() {
                run.run();
                return result;
            }
        });
    }

    static final class InvokeAsync<R>
    implements Observable.OnSubscribeFunc<R> {
        final Callable<? extends R> callable;

        public InvokeAsync(Callable<? extends R> callable) {
            if (callable == null) {
                throw new NullPointerException("function");
            }
            this.callable = callable;
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> t1) {
            Subscription s = Subscriptions.empty();
            try {
                t1.onNext(this.callable.call());
            }
            catch (Throwable t) {
                t1.onError(t);
                return s;
            }
            t1.onCompleted();
            return s;
        }
    }
}

