/*
 * Decompiled with CFR 0.152.
 */
package spark.route;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.route.HttpMethod;
import spark.route.RouteMatch;
import spark.route.RouteMatcher;
import spark.utils.MimeParse;
import spark.utils.SparkUtils;

public class SimpleRouteMatcher
implements RouteMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRouteMatcher.class);
    private List<RouteEntry> routes = new ArrayList<RouteEntry>();

    @Override
    public List<RouteMatch> findTargetsForRequestedRoute(HttpMethod httpMethod, String path, String acceptType) {
        ArrayList<RouteMatch> matchSet = new ArrayList<RouteMatch>();
        List<RouteEntry> routeEntries = this.findTargetsForRequestedRoute(httpMethod, path);
        for (RouteEntry routeEntry : routeEntries) {
            if (acceptType != null) {
                String bestMatch = MimeParse.bestMatch(Arrays.asList(routeEntry.acceptedType), acceptType);
                if (!this.routeWithGivenAcceptType(bestMatch)) continue;
                matchSet.add(new RouteMatch(httpMethod, routeEntry.target, routeEntry.path, path, acceptType));
                continue;
            }
            matchSet.add(new RouteMatch(httpMethod, routeEntry.target, routeEntry.path, path, acceptType));
        }
        return matchSet;
    }

    @Override
    public RouteMatch findTargetForRequestedRoute(HttpMethod httpMethod, String path, String acceptType) {
        List<RouteEntry> routeEntries = this.findTargetsForRequestedRoute(httpMethod, path);
        RouteEntry entry = this.findTargetWithGivenAcceptType(routeEntries, acceptType);
        return entry != null ? new RouteMatch(httpMethod, entry.target, entry.path, path, acceptType) : null;
    }

    private RouteEntry findTargetWithGivenAcceptType(List<RouteEntry> routeMatchs, String acceptType) {
        if (acceptType != null && routeMatchs.size() > 0) {
            Map<String, RouteEntry> acceptedMimeTypes = this.getAcceptedMimeTypes(routeMatchs);
            String bestMatch = MimeParse.bestMatch(acceptedMimeTypes.keySet(), acceptType);
            if (this.routeWithGivenAcceptType(bestMatch)) {
                return acceptedMimeTypes.get(bestMatch);
            }
            return null;
        }
        if (routeMatchs.size() > 0) {
            return routeMatchs.get(0);
        }
        return null;
    }

    private boolean routeWithGivenAcceptType(String bestMatch) {
        return !"".equals(bestMatch);
    }

    private List<RouteEntry> findTargetsForRequestedRoute(HttpMethod httpMethod, String path) {
        ArrayList<RouteEntry> matchSet = new ArrayList<RouteEntry>();
        for (RouteEntry entry : this.routes) {
            if (!entry.matches(httpMethod, path)) continue;
            matchSet.add(entry);
        }
        return matchSet;
    }

    @Override
    public void parseValidateAddRoute(String route, String acceptType, Object target) {
        try {
            HttpMethod method;
            int singleQuoteIndex = route.indexOf(39);
            String httpMethod = route.substring(0, singleQuoteIndex).trim().toLowerCase();
            String url = route.substring(singleQuoteIndex + 1, route.length() - 1).trim();
            try {
                method = HttpMethod.valueOf(httpMethod);
            }
            catch (IllegalArgumentException e) {
                LOG.error("The @Route value: " + route + " has an invalid HTTP method part: " + httpMethod + ".");
                return;
            }
            this.addRoute(method, url, acceptType, target);
        }
        catch (Exception e) {
            LOG.error("The @Route value: " + route + " is not in the correct format", e);
        }
    }

    private void addRoute(HttpMethod method, String url, String acceptedType, Object target) {
        RouteEntry entry = new RouteEntry();
        entry.httpMethod = method;
        entry.path = url;
        entry.target = target;
        entry.acceptedType = acceptedType;
        LOG.debug("Adds route: " + entry);
        this.routes.add(entry);
    }

    private Map<String, RouteEntry> getAcceptedMimeTypes(List<RouteEntry> routes) {
        HashMap<String, RouteEntry> acceptedTypes = new HashMap<String, RouteEntry>();
        for (RouteEntry routeEntry : routes) {
            if (acceptedTypes.containsKey(routeEntry.acceptedType)) continue;
            acceptedTypes.put(routeEntry.acceptedType, routeEntry);
        }
        return acceptedTypes;
    }

    @Override
    public void clearRoutes() {
        this.routes.clear();
    }

    private static class RouteEntry {
        private HttpMethod httpMethod;
        private String path;
        private String acceptedType;
        private Object target;

        private RouteEntry() {
        }

        private boolean matches(HttpMethod httpMethod, String path) {
            if ((httpMethod == HttpMethod.before || httpMethod == HttpMethod.after) && this.httpMethod == httpMethod && this.path.equals("+/*paths")) {
                return true;
            }
            boolean match = false;
            if (this.httpMethod == httpMethod) {
                match = this.matchPath(path);
            }
            return match;
        }

        private boolean matchPath(String path) {
            int pathSize;
            if (!this.path.endsWith("*") && (path.endsWith("/") && !this.path.endsWith("/") || this.path.endsWith("/") && !path.endsWith("/"))) {
                return false;
            }
            if (this.path.equals(path)) {
                return true;
            }
            List<String> thisPathList = SparkUtils.convertRouteToList(this.path);
            List<String> pathList = SparkUtils.convertRouteToList(path);
            int thisPathSize = thisPathList.size();
            if (thisPathSize == (pathSize = pathList.size())) {
                for (int i = 0; i < thisPathSize; ++i) {
                    String thisPathPart = thisPathList.get(i);
                    String pathPart = pathList.get(i);
                    if (i == thisPathSize - 1 && thisPathPart.equals("*") && this.path.endsWith("*")) {
                        return true;
                    }
                    if (thisPathPart.startsWith(":") || thisPathPart.equals(pathPart) || thisPathPart.equals("*")) continue;
                    return false;
                }
                return true;
            }
            if (this.path.endsWith("*")) {
                if (pathSize == thisPathSize - 1 && path.endsWith("/")) {
                    pathList.add("");
                    pathList.add("");
                    pathSize += 2;
                }
                if (thisPathSize < pathSize) {
                    for (int i = 0; i < thisPathSize; ++i) {
                        String thisPathPart = thisPathList.get(i);
                        String pathPart = pathList.get(i);
                        if (thisPathPart.equals("*") && i == thisPathSize - 1 && this.path.endsWith("*")) {
                            return true;
                        }
                        if (thisPathPart.startsWith(":") || thisPathPart.equals(pathPart) || thisPathPart.equals("*")) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.httpMethod.name() + ", " + this.path + ", " + this.target;
        }
    }
}

