/*
 * Decompiled with CFR 0.152.
 */
package spark.webserver;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Access;
import spark.Filter;
import spark.HaltException;
import spark.Request;
import spark.RequestResponseFactory;
import spark.Response;
import spark.Route;
import spark.route.HttpMethod;
import spark.route.RouteMatch;
import spark.route.RouteMatcher;
import spark.webserver.NotConsumedException;
import spark.webserver.RequestWrapper;
import spark.webserver.ResponseWrapper;

public class MatcherFilter
implements javax.servlet.Filter {
    private static final String ACCEPT_TYPE_REQUEST_MIME_HEADER = "Accept";
    private RouteMatcher routeMatcher;
    private boolean isServletContext;
    private boolean hasOtherHandlers;
    private static final Logger LOG = LoggerFactory.getLogger(MatcherFilter.class);
    private static final String NOT_FOUND = "<html><body><h2>404 Not found</h2>The requested route [%s] has not been mapped in Spark</body></html>";
    private static final String INTERNAL_ERROR = "<html><body><h2>500 Internal Error</h2></body></html>";

    public MatcherFilter(RouteMatcher routeMatcher, boolean isServletContext, boolean hasOtherHandlers) {
        this.routeMatcher = routeMatcher;
        this.isServletContext = isServletContext;
        this.hasOtherHandlers = hasOtherHandlers;
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        boolean consumed;
        long t0 = System.currentTimeMillis();
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String httpMethodStr = httpRequest.getMethod().toLowerCase();
        String uri = httpRequest.getRequestURI();
        String acceptType = httpRequest.getHeader(ACCEPT_TYPE_REQUEST_MIME_HEADER);
        String bodyContent = null;
        RequestWrapper req = new RequestWrapper();
        ResponseWrapper res = new ResponseWrapper();
        LOG.debug("httpMethod:" + httpMethodStr + ", uri: " + uri);
        try {
            List<RouteMatch> matchSet = this.routeMatcher.findTargetsForRequestedRoute(HttpMethod.before, uri, acceptType);
            for (RouteMatch filterMatch : matchSet) {
                Object filterTarget = filterMatch.getTarget();
                if (!(filterTarget instanceof Filter)) continue;
                Request request = RequestResponseFactory.create(filterMatch, httpRequest);
                Response response = RequestResponseFactory.create(httpResponse);
                Filter filter = (Filter)filterTarget;
                req.setDelegate(request);
                res.setDelegate(response);
                filter.handle(req, res);
                String bodyAfterFilter = Access.getBody(response);
                if (bodyAfterFilter == null) continue;
                bodyContent = bodyAfterFilter;
            }
            HttpMethod httpMethod = HttpMethod.valueOf(httpMethodStr);
            RouteMatch match = null;
            match = this.routeMatcher.findTargetForRequestedRoute(httpMethod, uri, acceptType);
            Object target = null;
            if (match != null) {
                target = match.getTarget();
            } else if (httpMethod == HttpMethod.head && bodyContent == null) {
                String string = bodyContent = this.routeMatcher.findTargetForRequestedRoute(HttpMethod.get, uri, acceptType) != null ? "" : null;
            }
            if (target != null) {
                try {
                    String result = null;
                    if (target instanceof Route) {
                        Route route = (Route)target;
                        Request request = RequestResponseFactory.create(match, httpRequest);
                        Response response = RequestResponseFactory.create(httpResponse);
                        req.setDelegate(request);
                        res.setDelegate(response);
                        Object element = route.handle(req, res);
                        result = route.render(element);
                    }
                    if (result != null) {
                        bodyContent = result;
                    }
                    long t1 = System.currentTimeMillis() - t0;
                    LOG.debug("Time for request: " + t1);
                }
                catch (HaltException hEx) {
                    throw hEx;
                }
                catch (Exception e) {
                    LOG.error("", e);
                    httpResponse.setStatus(500);
                    bodyContent = INTERNAL_ERROR;
                }
            }
            matchSet = this.routeMatcher.findTargetsForRequestedRoute(HttpMethod.after, uri, acceptType);
            for (RouteMatch filterMatch : matchSet) {
                Object filterTarget = filterMatch.getTarget();
                if (!(filterTarget instanceof Filter)) continue;
                Request request = RequestResponseFactory.create(filterMatch, httpRequest);
                Response response = RequestResponseFactory.create(httpResponse);
                req.setDelegate(request);
                res.setDelegate(response);
                Filter filter = (Filter)filterTarget;
                filter.handle(req, res);
                String bodyAfterFilter = Access.getBody(response);
                if (bodyAfterFilter == null) continue;
                bodyContent = bodyAfterFilter;
            }
        }
        catch (HaltException hEx) {
            LOG.debug("halt performed");
            httpResponse.setStatus(hEx.getStatusCode());
            bodyContent = hEx.getBody() != null ? hEx.getBody() : "";
        }
        boolean bl = consumed = bodyContent != null;
        if (!consumed && this.hasOtherHandlers) {
            throw new NotConsumedException();
        }
        if (!consumed && !this.isServletContext) {
            httpResponse.setStatus(404);
            bodyContent = String.format(NOT_FOUND, uri);
            consumed = true;
        }
        if (consumed) {
            if (!httpResponse.isCommitted()) {
                if (httpResponse.getContentType() == null) {
                    httpResponse.setContentType("text/html; charset=utf-8");
                }
                httpResponse.getOutputStream().write(bodyContent.getBytes("utf-8"));
            }
        } else if (chain != null) {
            chain.doFilter(httpRequest, httpResponse);
        }
    }

    @Override
    public void destroy() {
    }
}

