/*
 * Decompiled with CFR 0.152.
 */
package spark.webserver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import spark.webserver.SparkServer;

class SparkServerImpl
implements SparkServer {
    private static final String NAME = "Spark";
    private Handler handler;
    private Server server;

    public SparkServerImpl(Handler handler) {
        this.handler = handler;
        System.setProperty("org.mortbay.log.class", "spark.JettyLogger");
    }

    @Override
    public void ignite(String host, int port, String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword, String staticFilesFolder, String externalFilesFolder) {
        ServerConnector connector = keystoreFile == null ? SparkServerImpl.createSocketConnector() : SparkServerImpl.createSecureSocketConnector(keystoreFile, keystorePassword, truststoreFile, truststorePassword);
        connector.setIdleTimeout(TimeUnit.HOURS.toMillis(1L));
        connector.setSoLingerTime(-1);
        connector.setHost(host);
        connector.setPort(port);
        this.server = connector.getServer();
        this.server.setConnectors(new Connector[]{connector});
        if (staticFilesFolder == null && externalFilesFolder == null) {
            this.server.setHandler(this.handler);
        } else {
            ArrayList<Handler> handlersInList = new ArrayList<Handler>();
            handlersInList.add(this.handler);
            SparkServerImpl.setStaticFileLocationIfPresent(staticFilesFolder, handlersInList);
            SparkServerImpl.setExternalStaticFileLocationIfPresent(externalFilesFolder, handlersInList);
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(handlersInList.toArray(new Handler[handlersInList.size()]));
            this.server.setHandler(handlers);
        }
        try {
            System.out.println("== Spark has ignited ...");
            System.out.println(">> Listening on " + host + ":" + port);
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    @Override
    public void stop() {
        System.out.print(">>> Spark shutting down...");
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
        System.out.println("done");
    }

    private static ServerConnector createSecureSocketConnector(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        SslContextFactory sslContextFactory = new SslContextFactory(keystoreFile);
        if (keystorePassword != null) {
            sslContextFactory.setKeyStorePassword(keystorePassword);
        }
        if (truststoreFile != null) {
            sslContextFactory.setTrustStorePath(truststoreFile);
        }
        if (truststorePassword != null) {
            sslContextFactory.setTrustStorePassword(truststorePassword);
        }
        return new ServerConnector(new Server(), sslContextFactory);
    }

    private static ServerConnector createSocketConnector() {
        return new ServerConnector(new Server());
    }

    private static void setStaticFileLocationIfPresent(String staticFilesRoute, List<Handler> handlersInList) {
        if (staticFilesRoute != null) {
            ResourceHandler resourceHandler = new ResourceHandler();
            Resource staticResources = Resource.newClassPathResource(staticFilesRoute);
            resourceHandler.setBaseResource(staticResources);
            resourceHandler.setWelcomeFiles(new String[]{"index.html"});
            handlersInList.add(resourceHandler);
        }
    }

    private static void setExternalStaticFileLocationIfPresent(String externalFilesRoute, List<Handler> handlersInList) {
        if (externalFilesRoute != null) {
            try {
                ResourceHandler externalResourceHandler = new ResourceHandler();
                Resource externalStaticResources = Resource.newResource(new File(externalFilesRoute));
                externalResourceHandler.setBaseResource(externalStaticResources);
                externalResourceHandler.setWelcomeFiles(new String[]{"index.html"});
                handlersInList.add(externalResourceHandler);
            }
            catch (IOException exception) {
                exception.printStackTrace();
                System.err.println("Error during initialize external resource " + externalFilesRoute);
            }
        }
    }
}

