/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.reporter.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;

public class NewtsReporter
extends ScheduledReporter {
    private final SampleRepository repository;
    private final String name;
    private final Clock clock;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private NewtsReporter(MetricRegistry registry, SampleRepository repository, String name, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, MetricFilter filter) {
        super(registry, "newts-reporter", filter, rateUnit, durationUnit);
        this.repository = repository;
        this.name = name;
        this.clock = clock;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        Timestamp timestamp = Timestamp.fromEpochMillis((long)this.clock.getTime());
        ArrayList samples = Lists.newArrayList();
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.reportGauge(samples, timestamp, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.reportCounter(samples, timestamp, entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.reportHistogram(samples, timestamp, entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.reportMeter(samples, timestamp, entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.reportTimer(samples, timestamp, entry.getKey(), (Timer)entry.getValue());
        }
        this.repository.insert((Collection)samples);
    }

    private void reportTimer(List<Sample> samples, Timestamp timestamp, String name, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        HashMap rateAttr = Maps.newHashMap();
        rateAttr.put("rate_unit", this.getRateUnit());
        HashMap durationAttr = Maps.newHashMap();
        durationAttr.put("duration_unit", this.getDurationUnit());
        this.reportC(samples, timestamp, name, "count", timer.getCount());
        this.reportG(samples, timestamp, name, "max", this.convertDuration(snapshot.getMax()), durationAttr);
        this.reportG(samples, timestamp, name, "mean", this.convertDuration(snapshot.getMean()), durationAttr);
        this.reportG(samples, timestamp, name, "min", this.convertDuration(snapshot.getMin()), durationAttr);
        this.reportG(samples, timestamp, name, "stddev", this.convertDuration(snapshot.getStdDev()), durationAttr);
        this.reportG(samples, timestamp, name, "p50", this.convertDuration(snapshot.getMedian()), durationAttr);
        this.reportG(samples, timestamp, name, "p75", this.convertDuration(snapshot.get75thPercentile()), durationAttr);
        this.reportG(samples, timestamp, name, "p95", this.convertDuration(snapshot.get95thPercentile()), durationAttr);
        this.reportG(samples, timestamp, name, "p98", this.convertDuration(snapshot.get98thPercentile()), durationAttr);
        this.reportG(samples, timestamp, name, "p99", this.convertDuration(snapshot.get99thPercentile()), durationAttr);
        this.reportG(samples, timestamp, name, "p999", this.convertDuration(snapshot.get999thPercentile()), durationAttr);
        this.reportG(samples, timestamp, name, "mean_rate", this.convertRate(timer.getMeanRate()), rateAttr);
        this.reportG(samples, timestamp, name, "m1_rate", this.convertRate(timer.getOneMinuteRate()), rateAttr);
        this.reportG(samples, timestamp, name, "m5_rate", this.convertRate(timer.getFiveMinuteRate()), rateAttr);
        this.reportG(samples, timestamp, name, "m15_rate", this.convertRate(timer.getFifteenMinuteRate()), rateAttr);
    }

    private void reportMeter(List<Sample> samples, Timestamp timestamp, String name, Meter meter) {
        HashMap attrs = Maps.newHashMap();
        attrs.put("rate_unit", this.getRateUnit());
        this.reportC(samples, timestamp, name, "count", meter.getCount());
        this.reportG(samples, timestamp, name, "mean_rate", this.convertRate(meter.getMeanRate()), attrs);
        this.reportG(samples, timestamp, name, "m1_rate", this.convertRate(meter.getOneMinuteRate()), attrs);
        this.reportG(samples, timestamp, name, "m5_rate", this.convertRate(meter.getFiveMinuteRate()), attrs);
        this.reportG(samples, timestamp, name, "m15_rate", this.convertRate(meter.getFifteenMinuteRate()), attrs);
    }

    private void reportHistogram(List<Sample> samples, Timestamp timestamp, String name, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        this.reportC(samples, timestamp, name, "count", histogram.getCount());
        this.reportG(samples, timestamp, name, "max", snapshot.getMax());
        this.reportG(samples, timestamp, name, "mean", snapshot.getMean());
        this.reportG(samples, timestamp, name, "min", snapshot.getMin());
        this.reportG(samples, timestamp, name, "stddev", snapshot.getStdDev());
        this.reportG(samples, timestamp, name, "p50", snapshot.getMedian());
        this.reportG(samples, timestamp, name, "p75", snapshot.get75thPercentile());
        this.reportG(samples, timestamp, name, "p95", snapshot.get95thPercentile());
        this.reportG(samples, timestamp, name, "p98", snapshot.get98thPercentile());
        this.reportG(samples, timestamp, name, "p99", snapshot.get99thPercentile());
        this.reportG(samples, timestamp, name, "p999", snapshot.get999thPercentile());
    }

    private void reportCounter(List<Sample> samples, Timestamp timestamp, String name, Counter counter) {
        this.reportC(samples, timestamp, name, "count", counter.getCount());
    }

    private void reportGauge(List<Sample> samples, Timestamp timestamp, String name, Gauge<?> gauge) {
        Optional<Double> val = this.value(gauge.getValue());
        if (val.isPresent()) {
            this.reportG(samples, timestamp, name, "value", (Double)val.get());
        }
    }

    private void reportC(List<Sample> samples, Timestamp timestamp, String resource, String metricName, long count) {
        samples.add(new Sample(timestamp, this.resourceFor(resource), metricName, MetricType.COUNTER, this.counter(count)));
    }

    private void reportG(List<Sample> samples, Timestamp timestamp, String resource, String metricName, double val) {
        Sample s = new Sample(timestamp, this.resourceFor(resource), metricName, MetricType.GAUGE, this.gauge(val));
        samples.add(s);
    }

    private void reportG(List<Sample> samples, Timestamp timestamp, String resource, String metricName, double val, Map<String, String> attrs) {
        Sample s = new Sample(timestamp, this.resourceFor(resource), metricName, MetricType.GAUGE, this.gauge(val), attrs);
        samples.add(s);
    }

    private ValueType<?> counter(long count) {
        return ValueType.compose((Number)count, (MetricType)MetricType.COUNTER);
    }

    private ValueType<?> gauge(double val) {
        return ValueType.compose((Number)val, (MetricType)MetricType.GAUGE);
    }

    private Optional<Double> value(Object val) {
        return val instanceof Number ? Optional.of((Object)((Number)val).doubleValue()) : Optional.absent();
    }

    private Resource resourceFor(String name) {
        return new Resource(String.format("%s-%s", this.name, name));
    }

    public static class Builder {
        private final MetricRegistry registry;
        private String name;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private Clock clock;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.clock = Clock.defaultClock();
            this.filter = MetricFilter.ALL;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public NewtsReporter build(SampleRepository repository) {
            return new NewtsReporter(this.registry, repository, this.name, this.rateUnit, this.durationUnit, this.clock, this.filter);
        }
    }
}

