/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api.search.query;

import java.io.Reader;
import java.io.StringReader;
import org.opennms.newts.api.search.BooleanQuery;
import org.opennms.newts.api.search.Query;
import org.opennms.newts.api.search.query.ParseException;
import org.opennms.newts.api.search.query.TokenMgrError;

public abstract class QueryParserBase {
    public abstract void ReInit(Reader var1);

    public abstract Query TopLevelQuery() throws ParseException;

    public Query parse(String query) throws ParseException {
        this.ReInit(new StringReader(query));
        try {
            Query q = this.TopLevelQuery();
            return q != null ? q : new BooleanQuery();
        }
        catch (ParseException | TokenMgrError qpe) {
            ParseException e = new ParseException("Cannot parse '" + query + "': " + qpe.getMessage());
            e.initCause(qpe);
            throw e;
        }
    }

    protected String discardEscapeChar(String input) throws ParseException {
        char[] output = new char[input.length()];
        int length = 0;
        boolean lastCharWasEscapeChar = false;
        for (int i = 0; i < input.length(); ++i) {
            char curChar = input.charAt(i);
            if (!lastCharWasEscapeChar && curChar == '\\') {
                lastCharWasEscapeChar = true;
                continue;
            }
            output[length++] = curChar;
            lastCharWasEscapeChar = false;
        }
        if (lastCharWasEscapeChar) {
            throw new ParseException("Term can not end with escape character.");
        }
        return new String(output, 0, length);
    }
}

