/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.yammer.dropwizard.jersey.params.AbstractParam;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.opennms.newts.api.Duration;

public class DurationParam
extends AbstractParam<Duration> {
    private static final PeriodFormatter formatter = new PeriodFormatterBuilder().appendWeeks().appendSuffix("w").appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").toFormatter();

    protected DurationParam(String input) {
        super(input);
    }

    protected String errorMessage(String input, Exception e) {
        return String.format("Unable to parse '%s' as resolution", input);
    }

    protected Duration parse(String input) throws Exception {
        if (input.matches("^[\\d]+$")) {
            return Duration.seconds((long)Integer.valueOf(input).intValue());
        }
        Period period = formatter.parsePeriod(input);
        return Duration.seconds((long)period.toStandardDuration().getStandardSeconds());
    }
}

