/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yammer.dropwizard.Service;
import com.yammer.dropwizard.cli.ConfiguredCommand;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.lifecycle.Managed;
import com.yammer.metrics.core.HealthCheck;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.search.Searcher;
import org.opennms.newts.rest.CassandraGuiceModule;
import org.opennms.newts.rest.IllegalArgumentExceptionMapper;
import org.opennms.newts.rest.InitCommand;
import org.opennms.newts.rest.MeasurementsResource;
import org.opennms.newts.rest.NewtsConfig;
import org.opennms.newts.rest.NewtsGuiceModule;
import org.opennms.newts.rest.RepositoryHealthCheck;
import org.opennms.newts.rest.SamplesResource;
import org.opennms.newts.rest.SearchResource;

public class NewtsService
extends Service<NewtsConfig> {
    public static void main(String ... args) throws Exception {
        new NewtsService().run(args);
    }

    public void initialize(Bootstrap<NewtsConfig> bootstrap) {
        bootstrap.setName("newts");
        bootstrap.addCommand((ConfiguredCommand)new InitCommand());
    }

    public void run(NewtsConfig config, Environment environment) throws Exception {
        environment.addFilter(CrossOriginFilter.class, "/*");
        Injector injector = Guice.createInjector((Module[])new Module[]{new NewtsGuiceModule(), new CassandraGuiceModule(config)});
        MetricRegistry metricRegistry = (MetricRegistry)injector.getInstance(MetricRegistry.class);
        final JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain("newts").build();
        environment.manage(new Managed(){

            public void stop() throws Exception {
                reporter.stop();
            }

            public void start() throws Exception {
                reporter.start();
            }
        });
        SampleRepository repository = (SampleRepository)injector.getInstance(SampleRepository.class);
        environment.addResource((Object)new MeasurementsResource(repository, config.getReports()));
        environment.addResource((Object)new SamplesResource(repository));
        if (config.getSearchConfig().isEnabled()) {
            environment.addResource((Object)new SearchResource((Searcher)injector.getInstance(Searcher.class)));
        }
        environment.addHealthCheck((HealthCheck)new RepositoryHealthCheck(repository));
        environment.addProvider(IllegalArgumentExceptionMapper.class);
    }
}

