/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.yammer.metrics.annotation.Timed;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.rest.SampleDTO;
import org.opennms.newts.rest.Transform;

@Path(value="/samples")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SamplesResource {
    private final SampleRepository m_sampleRepository;

    public SamplesResource(SampleRepository sampleRepository) {
        this.m_sampleRepository = (SampleRepository)Preconditions.checkNotNull((Object)sampleRepository, (Object)"sample repository");
    }

    @POST
    @Timed
    public Response writeSamples(Collection<SampleDTO> samples) {
        this.m_sampleRepository.insert(Transform.samples(samples));
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Timed
    @Path(value="/{resource}")
    public Collection<Collection<SampleDTO>> getSamples(@PathParam(value="resource") Resource resource, @QueryParam(value="start") Optional<String> start, @QueryParam(value="end") Optional<String> end) {
        Optional<Timestamp> lower = Transform.timestampFromString(start);
        Optional<Timestamp> upper = Transform.timestampFromString(end);
        return Transform.sampleDTOs((Results<Sample>)this.m_sampleRepository.select(resource, lower, upper));
    }
}

