/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.yammer.dropwizard.jersey.params.AbstractParam;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opennms.newts.api.Timestamp;

public class TimestampParam
extends AbstractParam<Timestamp> {
    private static final DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();

    public TimestampParam(String input) {
        super(input);
    }

    protected String errorMessage(String input, Exception e) {
        return String.format("Unable to parse '%s' as date-time", input);
    }

    protected Timestamp parse(String input) throws Exception {
        if (input.matches("^[\\d]+$")) {
            return Timestamp.fromEpochSeconds((long)Integer.valueOf(input).intValue());
        }
        DateTime dateTime = parser.parseDateTime(input);
        return Timestamp.fromEpochMillis((long)dateTime.getMillis());
    }
}

