/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.net.URL;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.search.Searcher;
import org.opennms.newts.rest.CassandraGuiceModule;
import org.opennms.newts.rest.HttpBasicAuthenticationFilter;
import org.opennms.newts.rest.IllegalArgumentExceptionMapper;
import org.opennms.newts.rest.InitCommand;
import org.opennms.newts.rest.MeasurementsResource;
import org.opennms.newts.rest.NewtsConfig;
import org.opennms.newts.rest.NewtsGuiceModule;
import org.opennms.newts.rest.RepositoryHealthCheck;
import org.opennms.newts.rest.SamplesResource;
import org.opennms.newts.rest.SearchResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewtsService
extends Application<NewtsConfig> {
    private static final String UI_URL_PATH = "/ui";
    private static final Logger LOG = LoggerFactory.getLogger(NewtsService.class);

    public static void main(String ... args) throws Exception {
        new NewtsService().run(args);
    }

    public String getName() {
        return "newts";
    }

    public void initialize(Bootstrap<NewtsConfig> bootstrap) {
        bootstrap.addCommand((ConfiguredCommand)new InitCommand());
        bootstrap.addBundle((Bundle)new AssetsBundle("/app", UI_URL_PATH, "index.html"));
    }

    public void run(NewtsConfig config, Environment environment) throws Exception {
        this.configureCors(environment);
        this.configureUIRedirect(environment);
        this.configureAuthentication(environment, config);
        Injector injector = Guice.createInjector((Module[])new Module[]{new NewtsGuiceModule(), new CassandraGuiceModule(config)});
        MetricRegistry metricRegistry = (MetricRegistry)injector.getInstance(MetricRegistry.class);
        final JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain("newts").build();
        environment.lifecycle().manage(new Managed(){

            public void stop() throws Exception {
                reporter.stop();
            }

            public void start() throws Exception {
                reporter.start();
            }
        });
        SampleRepository repository = (SampleRepository)injector.getInstance(SampleRepository.class);
        environment.jersey().register((Object)new MeasurementsResource(repository, config.getReports()));
        environment.jersey().register((Object)new SamplesResource(repository));
        if (config.getSearchConfig().isEnabled()) {
            environment.jersey().register((Object)new SearchResource((Searcher)injector.getInstance(Searcher.class)));
        }
        environment.healthChecks().register("repository", (HealthCheck)new RepositoryHealthCheck(repository));
        environment.jersey().register(IllegalArgumentExceptionMapper.class);
    }

    private void configureAuthentication(Environment environment, NewtsConfig config) {
        if (config.getAuthenticationConfig().isEnabled()) {
            environment.servlets().addFilter("BasicAuth", (Filter)new HttpBasicAuthenticationFilter(config)).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
        }
    }

    private void configureUIRedirect(Environment environment) {
        environment.servlets().addFilter("TrailingSlashRedirect", new Filter(){

            public void init(FilterConfig cfg) throws ServletException {
                LOG.info("Initializing redirect filter");
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                StringBuffer url = ((HttpServletRequest)request).getRequestURL();
                String path = new URL(url.toString()).getPath();
                if (path.endsWith(NewtsService.UI_URL_PATH)) {
                    LOG.debug("Caught request to malformed URL {}, redirecting...", (Object)NewtsService.UI_URL_PATH);
                    ((HttpServletResponse)response).sendRedirect(String.format("%s/", url.toString()));
                } else {
                    chain.doFilter(request, response);
                }
            }

            public void destroy() {
            }
        }).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
    }

    private void configureCors(Environment environment) {
        FilterRegistration.Dynamic filter = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        filter.setInitParameter("allowedMethods", "GET,PUT,POST,DELETE,OPTIONS");
        filter.setInitParameter("allowedOrigins", "*");
        filter.setInitParameter("Access-Control-Allow-Origin", "*");
        filter.setInitParameter("allowedHeaders", "Content-Type,Authorization,X-Requested-With,Content-Length,Accept,Origin");
        filter.setInitParameter("allowCredentials", "true");
    }
}

