/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.opennms.newts.api.search.Query;
import org.opennms.newts.api.search.SearchResults;
import org.opennms.newts.api.search.Searcher;
import org.opennms.newts.api.search.query.ParseException;
import org.opennms.newts.api.search.query.QueryParser;

@Path(value="/search")
@Produces(value={"application/json"})
public class SearchResource {
    private final Searcher m_searcher;

    public SearchResource(Searcher searcher) {
        this.m_searcher = (Searcher)Preconditions.checkNotNull((Object)searcher, (Object)"searcher argument");
    }

    @GET
    @Timed
    public SearchResults search(@QueryParam(value="q") Optional<String> query) {
        Query parsedQuery;
        Preconditions.checkArgument((boolean)query.isPresent(), (Object)"missing required query parameter (q=<argument>)");
        QueryParser qp = new QueryParser();
        try {
            parsedQuery = qp.parse((String)query.get());
        }
        catch (ParseException e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid query " + (String)query.get())).build());
        }
        return this.m_searcher.search(parsedQuery);
    }
}

