/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.opennms.newts.api.SampleProcessor;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.search.Searcher;
import org.opennms.newts.cassandra.search.CassandraIndexerSampleProcessor;
import org.opennms.newts.cassandra.search.CassandraSearcher;
import org.opennms.newts.cassandra.search.GuavaResourceMetadataCache;
import org.opennms.newts.cassandra.search.ResourceMetadataCache;
import org.opennms.newts.persistence.cassandra.CassandraSampleRepository;
import org.opennms.newts.persistence.cassandra.ContextConfigurations;
import org.opennms.newts.rest.ContextConfig;
import org.opennms.newts.rest.NewtsConfig;

public class CassandraGuiceModule
extends AbstractModule {
    private final NewtsConfig m_newtsConf;

    public CassandraGuiceModule(NewtsConfig newtsConfig) {
        this.m_newtsConf = (NewtsConfig)((Object)Preconditions.checkNotNull((Object)((Object)newtsConfig), (Object)"newtsConfig argument"));
    }

    protected void configure() {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"cassandra.keyspace")).toInstance((Object)this.m_newtsConf.getCassandraKeyspace());
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"cassandra.hostname")).toInstance((Object)this.m_newtsConf.getCassandraHost());
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"cassandra.port")).toInstance((Object)this.m_newtsConf.getCassandraPort());
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"cassandra.compression")).toInstance((Object)this.m_newtsConf.getCassandraCompression());
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"samples.cassandra.time-to-live")).toInstance((Object)this.m_newtsConf.getCassandraColumnTTL());
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"search.cassandra.time-to-live")).toInstance((Object)this.m_newtsConf.getCassandraColumnTTL());
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"sampleProcessor.maxThreads")).toInstance((Object)this.m_newtsConf.getMaxSampleProcessorThreads());
        this.bind(Long.class).annotatedWith((Annotation)Names.named((String)"search.resourceMetadata.maxCacheEntries")).toInstance((Object)this.m_newtsConf.getSearchConfig().getMaxCacheEntries());
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"search.hierarical-indexing")).toInstance((Object)this.m_newtsConf.getSearchConfig().isHierarchicalIndexingEnabled());
        this.bind(ResourceMetadataCache.class).to(GuavaResourceMetadataCache.class);
        this.bind(Searcher.class).to(CassandraSearcher.class);
        this.bind(SampleRepository.class).to(CassandraSampleRepository.class);
        Multibinder processors = Multibinder.newSetBinder((Binder)this.binder(), SampleProcessor.class);
        if (this.m_newtsConf.getSearchConfig().isEnabled()) {
            processors.addBinding().to(CassandraIndexerSampleProcessor.class);
        }
        ContextConfigurations contextConfigurations = new ContextConfigurations();
        for (ContextConfig contextConfig : this.m_newtsConf.getContextConfigs().values()) {
            contextConfigurations.addContextConfig(contextConfig.getContext(), contextConfig.getResourceShard());
        }
        this.bind(ContextConfigurations.class).toInstance((Object)contextConfigurations);
    }
}

