/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.opennms.newts.api.query.AggregationFunction;
import org.opennms.newts.api.query.ResultDescriptor;
import org.opennms.newts.api.search.SearchResults;
import org.opennms.newts.rest.DurationParam;
import org.opennms.newts.rest.MeasurementDTO;
import org.opennms.newts.rest.ResourceDTO;
import org.opennms.newts.rest.ResultDescriptorDTO;
import org.opennms.newts.rest.SampleDTO;
import org.opennms.newts.rest.SearchResultDTO;
import org.opennms.newts.rest.TimestampParam;

class Transform {
    private static final Function<SampleDTO, Sample> DTO_TO_SAMPLE = new Function<SampleDTO, Sample>(){

        public Sample apply(SampleDTO input) {
            return new Sample(Timestamp.fromEpochMillis((long)input.getTimestamp()), input.getContext(), new Resource(input.getResource().getId(), Transform.wrapMap(input.getResource().getAttributes())), input.getName(), input.getType(), ValueType.compose((Number)input.getValue(), (MetricType)input.getType()), input.getAttributes());
        }
    };

    private Transform() {
    }

    private static Optional<Map<String, String>> wrapMap(Map<String, String> map) {
        if (map == null) {
            return Optional.absent();
        }
        return Optional.of(map);
    }

    static ResultDescriptor resultDescriptor(ResultDescriptorDTO rDescriptorDTO) {
        ResultDescriptor rDescriptor = new ResultDescriptor(rDescriptorDTO.getInterval());
        for (ResultDescriptorDTO.Datasource ds : rDescriptorDTO.getDatasources()) {
            if (ds.getHeartbeat() != null) {
                rDescriptor.datasource(ds.getLabel(), ds.getSource(), ds.getHeartbeat(), (AggregationFunction)ds.getFunction());
                continue;
            }
            rDescriptor.datasource(ds.getLabel(), ds.getSource(), (AggregationFunction)ds.getFunction());
        }
        for (ResultDescriptorDTO.Expression expr : rDescriptorDTO.getExpressions()) {
            rDescriptor.expression(expr.getLabel(), expr.getExpression());
        }
        rDescriptor.export(rDescriptorDTO.getExports());
        return rDescriptor;
    }

    static Collection<Sample> samples(Collection<SampleDTO> samples) {
        return Collections2.transform(samples, DTO_TO_SAMPLE);
    }

    static Collection<Collection<SampleDTO>> sampleDTOs(Results<Sample> samples) {
        return Lists.newArrayList((Iterable)Iterables.transform(samples, (Function)new Function<Results.Row<Sample>, Collection<SampleDTO>>(){

            public Collection<SampleDTO> apply(Results.Row<Sample> input) {
                return Collections2.transform((Collection)input.getElements(), (Function)new Function<Sample, SampleDTO>(){

                    public SampleDTO apply(Sample input) {
                        return new SampleDTO(input.getTimestamp().asMillis(), new ResourceDTO(input.getResource().getId(), Transform.unwrapMap((Optional<Map<String, String>>)input.getResource().getAttributes())), input.getName(), input.getType(), (Number)input.getValue(), input.getAttributes(), input.getContext().getId());
                    }
                });
            }
        }));
    }

    static Collection<Collection<MeasurementDTO>> measurementDTOs(Results<Measurement> measurements) {
        return Lists.newArrayList((Iterable)Iterables.transform(measurements, (Function)new Function<Results.Row<Measurement>, Collection<MeasurementDTO>>(){

            public Collection<MeasurementDTO> apply(Results.Row<Measurement> input) {
                return Collections2.transform((Collection)input.getElements(), (Function)new Function<Measurement, MeasurementDTO>(){

                    public MeasurementDTO apply(Measurement input) {
                        return new MeasurementDTO(input.getTimestamp().asMillis(), new ResourceDTO(input.getResource().getId(), Transform.unwrapMap((Optional<Map<String, String>>)input.getResource().getAttributes())), input.getName(), input.getValue(), input.getAttributes());
                    }
                });
            }
        }));
    }

    public static Collection<SearchResultDTO> searchResultDTOs(SearchResults results) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)results, (Function)new Function<SearchResults.Result, SearchResultDTO>(){

            public SearchResultDTO apply(SearchResults.Result input) {
                return new SearchResultDTO(new ResourceDTO(input.getResource().getId(), Transform.unwrapMap((Optional<Map<String, String>>)input.getResource().getAttributes())), input.getMetrics());
            }
        }));
    }

    private static Map<String, String> unwrapMap(Optional<Map<String, String>> wrapped) {
        if (!wrapped.isPresent()) {
            return Collections.emptyMap();
        }
        return (Map)wrapped.get();
    }

    static Optional<Timestamp> toTimestamp(Optional<TimestampParam> value) {
        return value.isPresent() ? Optional.of((Object)((TimestampParam)((Object)value.get())).get()) : Optional.absent();
    }

    static Optional<Duration> toDuration(Optional<DurationParam> value) {
        return value.isPresent() ? Optional.of((Object)((DurationParam)((Object)value.get())).get()) : Optional.absent();
    }
}

