/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.rest.ResourceDTO;
import org.opennms.newts.rest.SampleDTOSerializer;

@JsonSerialize(using=SampleDTOSerializer.class)
public class SampleDTO {
    private final long m_timestamp;
    private final ResourceDTO m_resource;
    private final String m_name;
    private final MetricType m_type;
    private final Number m_value;
    private final Map<String, String> m_attributes;
    private final Context m_context;

    @JsonCreator
    public SampleDTO(@JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="resource") ResourceDTO resource, @JsonProperty(value="name") String name, @JsonProperty(value="type") MetricType type, @JsonProperty(value="value") Number value, @JsonProperty(value="attributes") Map<String, String> attributes, @JsonProperty(value="context") String context) {
        this.m_timestamp = (Long)Preconditions.checkNotNull((Object)timestamp, (Object)"m_timestamp argument");
        this.m_resource = (ResourceDTO)Preconditions.checkNotNull((Object)resource, (Object)"m_resource argument");
        this.m_name = (String)Preconditions.checkNotNull((Object)name, (Object)"m_name argument");
        this.m_type = (MetricType)Preconditions.checkNotNull((Object)type, (Object)"m_type argument");
        this.m_value = (Number)Preconditions.checkNotNull((Object)value, (Object)"m_value argument");
        this.m_attributes = attributes;
        this.m_context = context != null ? new Context(context) : Context.DEFAULT_CONTEXT;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public ResourceDTO getResource() {
        return this.m_resource;
    }

    public String getName() {
        return this.m_name;
    }

    public MetricType getType() {
        return this.m_type;
    }

    public Number getValue() {
        return this.m_value;
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public Context getContext() {
        return this.m_context;
    }
}

