/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.search.Indexer;
import org.opennms.newts.rest.SampleDTO;
import org.opennms.newts.rest.TimestampParam;
import org.opennms.newts.rest.Transform;

@Path(value="/samples")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SamplesResource {
    private final SampleRepository m_sampleRepository;
    private final Indexer m_indexer;

    public SamplesResource(SampleRepository sampleRepository, Indexer indexer) {
        this.m_sampleRepository = (SampleRepository)Preconditions.checkNotNull((Object)sampleRepository, (Object)"sample repository");
        this.m_indexer = (Indexer)Preconditions.checkNotNull((Object)indexer, (Object)"indexer");
    }

    @POST
    @Timed
    public Response writeSamples(Collection<SampleDTO> samples) {
        this.m_sampleRepository.insert(Transform.samples(samples));
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Timed
    @Path(value="/{resource}")
    public Collection<Collection<SampleDTO>> getSamples(@PathParam(value="resource") Resource resource, @QueryParam(value="start") Optional<TimestampParam> start, @QueryParam(value="end") Optional<TimestampParam> end, @QueryParam(value="context") Optional<String> contextId) {
        Optional<Timestamp> lower = Transform.toTimestamp(start);
        Optional<Timestamp> upper = Transform.toTimestamp(end);
        Context context = contextId.isPresent() ? new Context((String)contextId.get()) : Context.DEFAULT_CONTEXT;
        return Transform.sampleDTOs((Results<Sample>)this.m_sampleRepository.select(context, resource, lower, upper));
    }

    @DELETE
    @Timed
    @Path(value="/{resource}")
    public void deleteSamples(@PathParam(value="resource") Resource resource, @QueryParam(value="context") Optional<String> contextId) {
        Context context = contextId.isPresent() ? new Context((String)contextId.get()) : Context.DEFAULT_CONTEXT;
        this.m_sampleRepository.delete(context, resource);
        this.m_indexer.delete(context, resource);
    }
}

