/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.query.ResultDescriptor;
import org.opennms.newts.rest.DurationParam;
import org.opennms.newts.rest.MeasurementDTO;
import org.opennms.newts.rest.ResultDescriptorDTO;
import org.opennms.newts.rest.TimestampParam;
import org.opennms.newts.rest.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/measurements")
@Produces(value={"application/json"})
public class MeasurementsResource {
    private static final Logger LOG = LoggerFactory.getLogger(MeasurementsResource.class);
    private final SampleRepository m_repository;
    private final Map<String, ResultDescriptorDTO> m_reports;

    public MeasurementsResource(SampleRepository repository, Map<String, ResultDescriptorDTO> reports) {
        this.m_repository = (SampleRepository)Preconditions.checkNotNull((Object)repository, (Object)"repository argument");
        this.m_reports = (Map)Preconditions.checkNotNull(reports, (Object)"reports argument");
    }

    @POST
    @Path(value="/{resource}")
    @Timed
    public Collection<Collection<MeasurementDTO>> getMeasurements(ResultDescriptorDTO descriptorDTO, @PathParam(value="resource") Resource resource, @QueryParam(value="start") Optional<TimestampParam> start, @QueryParam(value="end") Optional<TimestampParam> end, @QueryParam(value="resolution") Optional<DurationParam> resolution, @QueryParam(value="context") Optional<String> contextId) {
        Optional<Timestamp> lower = Transform.toTimestamp(start);
        Optional<Timestamp> upper = Transform.toTimestamp(end);
        Optional<Duration> step = Transform.toDuration(resolution);
        Context context = contextId.isPresent() ? new Context((String)contextId.get()) : Context.DEFAULT_CONTEXT;
        LOG.debug("Retrieving measurements for resource {}, from {} to {} w/ resolution {} and w/ report {}", new Object[]{resource, lower, upper, step, descriptorDTO});
        ResultDescriptor rDescriptor = Transform.resultDescriptor(descriptorDTO);
        return Transform.measurementDTOs((Results<Measurement>)this.m_repository.select(context, resource, lower, upper, rDescriptor, step));
    }

    @GET
    @Path(value="/{report}/{resource}")
    @Timed
    public Collection<Collection<MeasurementDTO>> getMeasurements(@PathParam(value="report") String report, @PathParam(value="resource") Resource resource, @QueryParam(value="start") Optional<TimestampParam> start, @QueryParam(value="end") Optional<TimestampParam> end, @QueryParam(value="resolution") Optional<DurationParam> resolution, @QueryParam(value="context") Optional<String> contextId) {
        ResultDescriptorDTO descriptorDTO = this.m_reports.get(report);
        if (descriptorDTO == null) {
            return null;
        }
        return this.getMeasurements(descriptorDTO, resource, start, end, resolution, contextId);
    }
}

