/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.setup.Bootstrap;
import java.util.ServiceLoader;
import net.sourceforge.argparse4j.inf.Namespace;
import org.opennms.newts.cassandra.Schema;
import org.opennms.newts.cassandra.SchemaManager;
import org.opennms.newts.rest.NewtsConfig;

public class InitCommand
extends ConfiguredCommand<NewtsConfig> {
    private static ServiceLoader<Schema> s_schemas = ServiceLoader.load(Schema.class);

    protected InitCommand() {
        super("init", "Perform one-time application initialization");
    }

    protected void run(Bootstrap<NewtsConfig> bootstrap, Namespace namespace, NewtsConfig config) throws Exception {
        try (SchemaManager m = new SchemaManager(config.getCassandraKeyspace(), config.getCassandraHost(), config.getCassandraPort(), config.getCassandraUsername(), config.getCassandraPassword(), config.getCassandraSsl());){
            for (Schema s : s_schemas) {
                m.create(s, true);
            }
        }
    }
}

