/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.Configuration;
import java.util.Collections;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.opennms.newts.rest.AuthenticationConfig;
import org.opennms.newts.rest.CassandraConfig;
import org.opennms.newts.rest.ContextConfig;
import org.opennms.newts.rest.GraphiteConfig;
import org.opennms.newts.rest.ResultDescriptorDTO;
import org.opennms.newts.rest.SearchConfig;

public class NewtsConfig
extends Configuration {
    @Min(value=1L)
    @Max(value=8192L)
    @JsonProperty(value="maxSampleProcessorThreads")
    private int m_maxThreads = 64;
    @Valid
    @JsonProperty(value="search")
    private SearchConfig m_searchConfig = new SearchConfig();
    @Valid
    @JsonProperty(value="cassandra")
    private CassandraConfig m_cassandraConfig = new CassandraConfig();
    @Valid
    @JsonProperty(value="contexts")
    private Map<String, ContextConfig> m_contextConfigs = Collections.emptyMap();
    @Valid
    @JsonProperty(value="reports")
    private Map<String, ResultDescriptorDTO> m_reports = Collections.emptyMap();
    @Valid
    @JsonProperty(value="authentication")
    private AuthenticationConfig m_authenticationConfig = new AuthenticationConfig();
    @Valid
    @JsonProperty(value="graphite")
    private GraphiteConfig m_graphiteConfig = new GraphiteConfig();

    public int getMaxSampleProcessorThreads() {
        return this.m_maxThreads;
    }

    public SearchConfig getSearchConfig() {
        return this.m_searchConfig;
    }

    public String getCassandraKeyspace() {
        return this.m_cassandraConfig.getKeyspace();
    }

    public String getCassandraHost() {
        return this.m_cassandraConfig.getHost();
    }

    public int getCassandraPort() {
        return this.m_cassandraConfig.getPort();
    }

    public int getCassandraColumnTTL() {
        return this.m_cassandraConfig.getColumnTTL();
    }

    public String getCassandraCompression() {
        return this.m_cassandraConfig.getCompression();
    }

    public String getCassandraUsername() {
        return this.m_cassandraConfig.getUsername();
    }

    public String getCassandraPassword() {
        return this.m_cassandraConfig.getPassword();
    }

    public boolean getCassandraSsl() {
        return this.m_cassandraConfig.getSsl();
    }

    public Integer getCoreConnectionsPerHost() {
        return this.m_cassandraConfig.getCoreConnectionsPerHost();
    }

    public Integer getMaxConnectionsPerHost() {
        return this.m_cassandraConfig.getMaxConnectionsPerHost();
    }

    public Integer getMaxRequestsPerConnection() {
        return this.m_cassandraConfig.getMaxRequestsPerConnection();
    }

    public Map<String, ResultDescriptorDTO> getReports() {
        return this.m_reports;
    }

    public Map<String, ContextConfig> getContextConfigs() {
        return this.m_contextConfigs;
    }

    public AuthenticationConfig getAuthenticationConfig() {
        return this.m_authenticationConfig;
    }

    public GraphiteConfig getGraphiteConfig() {
        return this.m_graphiteConfig;
    }
}

