/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class RequisitionFileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RequisitionFileUtils.class);

    static void createPath(File fsPath) throws ForeignSourceRepositoryException {
        if (!fsPath.exists() && !fsPath.mkdirs()) {
            throw new ForeignSourceRepositoryException("unable to create directory " + fsPath.getPath());
        }
    }

    static File encodeFileName(String path, String foreignSourceName) {
        return new File(path, foreignSourceName + ".xml");
    }

    static ForeignSource getForeignSourceFromFile(File inputFile) throws ForeignSourceRepositoryException {
        return (ForeignSource)JaxbUtils.unmarshal(ForeignSource.class, (File)inputFile);
    }

    static Requisition getRequisitionFromFile(File inputFile) throws ForeignSourceRepositoryException {
        try {
            return (Requisition)JaxbUtils.unmarshal(Requisition.class, (File)inputFile);
        }
        catch (Throwable e) {
            throw new ForeignSourceRepositoryException("unable to unmarshal " + inputFile.getPath(), e);
        }
    }

    static File getOutputFileForForeignSource(String path, ForeignSource foreignSource) {
        File fsPath = new File(path);
        RequisitionFileUtils.createPath(fsPath);
        return RequisitionFileUtils.encodeFileName(path, foreignSource.getName());
    }

    public static File getOutputFileForRequisition(String path, Requisition requisition) {
        return RequisitionFileUtils.getOutputFileForRequisition(path, requisition.getForeignSource());
    }

    public static File getOutputFileForRequisition(String path, String foreignSource) {
        File reqPath = new File(path);
        RequisitionFileUtils.createPath(reqPath);
        return RequisitionFileUtils.encodeFileName(path, foreignSource);
    }

    public static File createSnapshot(ForeignSourceRepository repository, String foreignSource, Date date) {
        URL url = repository.getRequisitionURL(foreignSource);
        if (url == null) {
            LOG.warn("Unable to get requisition URL for foreign source {}", (Object)foreignSource);
            return null;
        }
        String sourceFileName = RequisitionFileUtils.getFilename(url);
        if (sourceFileName == null) {
            LOG.warn("Trying to create snapshot for {}, but getFile() doesn't return a value", (Object)url);
            return null;
        }
        File sourceFile = new File(sourceFileName);
        if (!sourceFile.exists()) {
            LOG.warn("Trying to create snapshot for {}, but {} does not exist.", (Object)url, (Object)sourceFileName);
            return null;
        }
        String targetFileName = sourceFileName + "." + date.getTime();
        File targetFile = new File(targetFileName);
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile, (boolean)true);
            return targetFile;
        }
        catch (IOException e) {
            LOG.warn("Failed to copy {} to {}", new Object[]{sourceFileName, targetFileName, e});
            return null;
        }
    }

    public static List<File> findSnapshots(ForeignSourceRepository repository, String foreignSource) {
        String sourceFileName;
        ArrayList<File> files = new ArrayList<File>();
        URL url = null;
        try {
            url = repository.getRequisitionURL(foreignSource);
        }
        catch (ForeignSourceRepositoryException e) {
            LOG.debug("Can't find snapshots for {}, an exception occurred getting the requisition URL!", (Object)foreignSource, (Object)e);
        }
        if (url != null && (sourceFileName = RequisitionFileUtils.getFilename(url)) != null) {
            File sourceFile = new File(sourceFileName);
            File sourceDirectory = sourceFile.getParentFile();
            for (File entry : sourceDirectory.listFiles()) {
                if (!RequisitionFileUtils.isSnapshot(foreignSource, entry)) continue;
                files.add(entry);
            }
        }
        return files;
    }

    private static boolean isSnapshot(String foreignSource, File entry) {
        return !entry.isDirectory() && entry.getName().matches(foreignSource + ".xml.\\d+");
    }

    public static void deleteResourceIfSnapshot(Requisition requisition) {
        Resource resource = requisition.getResource();
        if (resource == null) {
            return;
        }
        try {
            File resourceFile = resource.getFile();
            if (RequisitionFileUtils.isSnapshot(requisition.getForeignSource(), resourceFile)) {
                LOG.trace("Deleting {}", (Object)resourceFile);
                if (!resourceFile.delete()) {
                    LOG.debug("Failed to delete {}", (Object)resourceFile);
                }
            }
        }
        catch (IOException e) {
            LOG.debug("Resource {} can't be turned into a file, skipping snapshot delete detection.", (Object)resource, (Object)e);
            return;
        }
    }

    public static void deleteSnapshotsOlderThan(ForeignSourceRepository repository, String foreignSource, Date date) {
        for (File snapshotFile : RequisitionFileUtils.findSnapshots(repository, foreignSource)) {
            if (RequisitionFileUtils.isNewer(snapshotFile, date)) continue;
            LOG.trace("Deleting {}", (Object)snapshotFile);
            if (snapshotFile.delete()) continue;
            LOG.warn("Could not delete file: {}", (Object)snapshotFile.getPath());
        }
    }

    public static void deleteAllSnapshots(ForeignSourceRepository repository) {
        for (String foreignSource : repository.getActiveForeignSourceNames()) {
            List<File> snapshots = RequisitionFileUtils.findSnapshots(repository, foreignSource);
            for (File snapshot : snapshots) {
                LOG.trace("Deleting {}", (Object)snapshot);
                if (snapshot.delete()) continue;
                LOG.warn("Could not delete file: {}", (Object)snapshot.getPath());
            }
        }
    }

    public static Requisition getLatestPendingOrSnapshotRequisition(ForeignSourceRepository foreignSourceRepository, String foreignSource) {
        Requisition newest = foreignSourceRepository.getRequisition(foreignSource);
        for (File snapshotFile : RequisitionFileUtils.findSnapshots(foreignSourceRepository, foreignSource)) {
            if (newest != null && !RequisitionFileUtils.isNewer(snapshotFile, newest.getDate())) continue;
            newest = (Requisition)JaxbUtils.unmarshal(Requisition.class, (File)snapshotFile);
            newest.setResource((Resource)new FileSystemResource(snapshotFile));
        }
        return newest;
    }

    public static boolean isNewer(File snapshotFile, Date date) {
        String name = snapshotFile.getName();
        String timestamp = name.substring(name.lastIndexOf(46) + 1);
        Date snapshotDate = new Date(Long.valueOf(timestamp));
        boolean isNewer = snapshotDate.after(date);
        LOG.trace("snapshot date = {}, comparison date = {}, snapshot date {} newer than comparison date", new Object[]{snapshotDate.getTime(), date.getTime(), isNewer ? "is" : "is not"});
        return isNewer;
    }

    private static String getFilename(URL url) {
        try {
            return URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Failed to decode URL {} as a file.", (Object)url.getFile(), (Object)e);
            return null;
        }
    }
}

